/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombifiedpiglin;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.zombifiedpiglin._SpecialZombifiedPiglinEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class VampireZombifiedPiglinEntity
extends _SpecialZombifiedPiglinEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<VampireZombifiedPiglinEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().addExperience(4).addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Vampire Piglin", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        VampireZombifiedPiglinEntity.addBaseLoot(loot);
        loot.addSemicommonDrop("semicommon", (IItemProvider)Items.field_151128_bU);
        ItemStack stake = new ItemStack((IItemProvider)Items.field_151041_m);
        stake.func_77966_a(Enchantments.field_185303_l, Enchantments.field_185303_l.func_77325_b() * 2);
        loot.addRareDrop("rare", stake);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<VampireZombifiedPiglinEntity> getVariantFactory() {
        return VampireZombifiedPiglinEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends VampireZombifiedPiglinEntity> getSpecies() {
        return SPECIES;
    }

    public VampireZombifiedPiglinEntity(EntityType<? extends _SpecialZombifiedPiglinEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, Effects.field_76433_i, 2);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (MobHelper.isDamageSourceIneffectiveAgainstVampires(source)) {
            amount = Math.min(2.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }
}

