/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned.PlagueDrownedEntity;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class PlagueZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PlagueZombieEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x8AA838).theme(BestiaryInfo.Theme.FOREST).uniqueTextureBaseOnly().addExperience(1).multiplyAttribute(Attributes.field_233821_d_, 1.1);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Plague Zombie", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PlagueZombieEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151170_bI, Items.field_151070_bp, Items.field_151071_bq, Blocks.field_150337_Q, Blocks.field_150338_P});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<PlagueZombieEntity> getVariantFactory() {
        return PlagueZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PlagueZombieEntity> getSpecies() {
        return SPECIES;
    }

    public PlagueZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected EntityType<? extends ZombieEntity> getVariantConversionType() {
        return (EntityType)PlagueDrownedEntity.SPECIES.entityType.get();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyPlagueEffect(target, this.field_70146_Z);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipPlagueArrow(arrow, this.field_70146_Z);
    }
}

