/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.MadScientistZombieSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.IAmmoUser;
import fathertoast.specialmobs.common.entity.ai.goal.ChargeCreeperGoal;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class MadScientistZombieEntity
extends _SpecialZombieEntity
implements IAmmoUser {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MadScientistZombieEntity> SPECIES;
    private static final BiPredicate<MadScientistZombieEntity, ? super CreeperEntity> CHARGE_CREEPER_TARGET;
    private int chargeCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14603462).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(2).disableRangedAttack();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new MadScientistZombieSpeciesConfig(species, 0.0, 0.0, 1, 3);
    }

    @Override
    public MadScientistZombieSpeciesConfig getConfig() {
        return (MadScientistZombieSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mad Scientist Zombie", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MadScientistZombieEntity.addBaseLoot(loot);
        loot.addRareDrop("rare", (IItemProvider)SMItems.SYRINGE.get());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<MadScientistZombieEntity> getVariantFactory() {
        return MadScientistZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MadScientistZombieEntity> getSpecies() {
        return SPECIES;
    }

    public MadScientistZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, World world) {
        super(entityType, world);
        this.chargeCount = this.getConfig().MAD_SCIENTIST.chargeCount.next(this.field_70146_Z);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.field_70714_bg, 2, new ChargeCreeperGoal<MadScientistZombieEntity>(this, 1.25, 20.0, CHARGE_CREEPER_TARGET));
    }

    @Override
    protected int getVariantAttackPriority() {
        return super.getVariantAttackPriority() + 1;
    }

    @Override
    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SMItems.SYRINGE.get()));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.hasAmmo()) {
            MobHelper.applyEffect(target, Effects.field_76436_u);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.chargeCount <= 0 && this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == SMItems.SYRINGE.get()) {
            this.func_213361_c(EquipmentSlotType.MAINHAND);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean hasAmmo() {
        return this.chargeCount > 0;
    }

    @Override
    public void consumeAmmo() {
        --this.chargeCount;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Ammo", (byte)this.chargeCount);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Ammo", 99)) {
            this.chargeCount = saveTag.func_74771_c("Ammo");
        }
    }

    static {
        CHARGE_CREEPER_TARGET = (madman, creeper) -> creeper.func_70089_S() && !creeper.func_225509_J__() && madman.func_70635_at().func_75522_a((Entity)creeper);
    }
}

