/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.HuskZombieSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class HuskZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HuskZombieEntity> SPECIES;
    private static final Predicate<MobFamily.Species<?>> HUSK_CONVERSION_SELECTOR;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15125652).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.DESERT).vanillaTextureBaseOnly("textures/entity/zombie/husk.png").size(1.0625f, 0.6f, 1.95f).addExperience(1);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new HuskZombieSpeciesConfig(species, 0.05, 0.02);
    }

    @Override
    public HuskZombieSpeciesConfig getConfig() {
        return (HuskZombieSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return HuskEntity.func_234342_eQ_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends HuskZombieEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, HuskZombieEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends HuskZombieEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return NaturalSpawnManager.checkSpawnRulesDefault(type, world, reason, pos, random) && (reason == SpawnReason.SPAWNER || world.func_226660_f_(pos));
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Husk", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200763_C.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<HuskZombieEntity> getVariantFactory() {
        return HuskZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HuskZombieEntity> getSpecies() {
        return SPECIES;
    }

    public HuskZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76438_s);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, Effects.field_76438_s);
    }

    @Override
    protected void func_207302_dI() {
        this.func_234341_c_(this.getVariantConversionType());
        References.LevelEvent.HUSK_CONVERTED_TO_ZOMBIE.play((Entity)this);
    }

    @Override
    protected EntityType<? extends ZombieEntity> getVariantConversionType() {
        return this.getConfig().HUSK.convertVariantChance.rollChance(this.field_70146_Z, this.field_70170_p, this.func_233580_cy_()) ? (EntityType)MobFamily.ZOMBIE.nextVariant((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), HuskZombieEntity.HUSK_CONVERSION_SELECTOR, _SpecialZombieEntity.SPECIES).entityType.get() : (EntityType)_SpecialZombieEntity.SPECIES.entityType.get();
    }

    @Override
    protected boolean func_190730_o() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190022_cI;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190024_cK;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190023_cJ;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_190025_cL;
    }

    static {
        HUSK_CONVERSION_SELECTOR = species -> species != SPECIES && !species.config.GENERAL.isDamagedByWater.get();
    }
}

