/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.drowned.FrozenDrownedEntity;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class FrozenZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenZombieEntity> SPECIES;
    private static final AttributeModifier BURNING_SPEED_BOOST;
    private boolean wasBurning;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).addToAttribute(Attributes.field_233826_i_, 10.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Zombie", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenZombieEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Items.field_151126_ay);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_150432_aD});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FrozenZombieEntity> getVariantFactory() {
        return FrozenZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenZombieEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, WaterAvoidingRandomWalkingGoal.class);
        AIHelper.removeGoals(this.field_70714_bg, LookAtGoal.class);
        AIHelper.removeGoals(this.field_70714_bg, LookRandomlyGoal.class);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 2);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, Effects.field_76421_d);
    }

    @Override
    protected EntityType<? extends ZombieEntity> getVariantConversionType() {
        return (EntityType)FrozenDrownedEntity.SPECIES.entityType.get();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d() && this.wasBurning != this.func_223314_ad() > 0) {
            this.wasBurning = !this.wasBurning;
            ModifiableAttributeInstance attributeInstance = this.func_110148_a(Attributes.field_233821_d_);
            attributeInstance.func_111124_b(BURNING_SPEED_BOOST);
            if (this.wasBurning) {
                attributeInstance.func_233767_b_(BURNING_SPEED_BOOST);
            }
        }
        super.func_70636_d();
    }

    static {
        BURNING_SPEED_BOOST = new AttributeModifier(UUID.fromString("B4704571-9566-4402-BC1F-2EE2A276D836"), "AHHHHHHHHHHHHHHH", 0.75, AttributeModifier.Operation.MULTIPLY_BASE);
    }
}

