/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned.BruteDrownedEntity;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class BruteZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BruteZombieEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).uniqueTextureBaseOnly().size(1.2f, 0.7f, 2.35f).addExperience(2).addToAttribute(Attributes.field_233818_a_, 10.0).addToAttribute(Attributes.field_233826_i_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Zombie Brute", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BruteZombieEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151145_ak, 1);
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151042_j});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<BruteZombieEntity> getVariantFactory() {
        return BruteZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BruteZombieEntity> getSpecies() {
        return SPECIES;
    }

    public BruteZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected EntityType<? extends ZombieEntity> getVariantConversionType() {
        return (EntityType)BruteDrownedEntity.SPECIES.entityType.get();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.causeLifeLoss(target, 2.0f);
        MobHelper.knockback((Entity)this, target, 2.0f, 1.0f);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, Effects.field_76433_i);
    }
}

