/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialWitchEntity
extends WitchEntity
implements ISpecialMob<_SpecialWitchEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialWitchEntity> SPECIES;
    private static final AttributeModifier DRINKING_SPEED_PENALTY;
    private static final DataParameter<Float> SCALE;
    private boolean fakeDrinkingPotion;
    protected int potionDrinkTimer;
    protected int potionUseCooldownTimer;
    public ItemStack sheathedItem = ItemStack.field_190927_a;
    private SpecialMobData<_SpecialWitchEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(5349438).vanillaTextureBaseOnly("textures/entity/witch.png").experience(5).throwAttack(1.0, 1.0, 60, 10.0);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return WitchEntity.func_234323_eI_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialWitchEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch", "Bruja", "Bruxa", "Sorci\u00c3\u00a8re", "Strega", "Hexe", "Wizard");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200759_ay.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialWitchEntity> getFactory() {
        return _SpecialWitchEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void func_82196_d(LivingEntity target, float damageMulti) {
        if (this.func_184730_o()) {
            return;
        }
        Vector3d vTarget = target.func_213322_ci();
        double dX = target.func_226277_ct_() + vTarget.field_72450_a - this.func_226277_ct_();
        double dY = target.func_226280_cw_() - 1.1 - this.func_226278_cu_();
        double dZ = target.func_226281_cx_() + vTarget.field_72449_c - this.func_226281_cx_();
        float dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        ItemStack potion = this.pickThrownPotion(target, damageMulti, dH);
        if (potion.func_190926_b()) {
            return;
        }
        PotionEntity thrownPotion = new PotionEntity(this.field_70170_p, (LivingEntity)this);
        thrownPotion.func_213884_b(potion);
        thrownPotion.field_70125_A += 20.0f;
        thrownPotion.func_70186_c(dX, dY + (double)(dH * 0.2f), dZ, 0.75f, 8.0f * this.getSpecialData().getRangedAttackSpread());
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.field_70170_p.func_217376_c((Entity)thrownPotion);
    }

    protected ItemStack pickThrownPotion(LivingEntity target, float damageMulti, float distance) {
        if (target instanceof AbstractRaiderEntity) {
            ItemStack potion = target.func_70668_bt() == CreatureAttribute.field_223223_b_ ? this.makeSplashPotion(Potions.field_185252_x) : (target.func_110143_aJ() <= 4.0f ? this.makeSplashPotion(Potions.field_185250_v) : this.makeSplashPotion(Potions.field_185220_C));
            this.func_70624_b(null);
            return this.pickVariantSupportPotion(potion, (AbstractRaiderEntity)target, distance);
        }
        ItemStack potion = distance >= 8.0f && !target.func_70644_a(Effects.field_76421_d) ? this.makeSplashPotion(Potions.field_185246_r) : (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(Effects.field_76436_u) ? this.makeSplashPotion(Potions.field_185254_z) : (distance <= 3.0f && !target.func_70644_a(Effects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f ? this.makeSplashPotion(Potions.field_185226_I) : (target.func_70668_bt() == CreatureAttribute.field_223223_b_ ? this.makeSplashPotion(Potions.field_185250_v) : this.makeSplashPotion(Potions.field_185252_x))));
        return this.pickVariantThrownPotion(potion, target, damageMulti, distance);
    }

    protected ItemStack pickVariantSupportPotion(ItemStack originalPotion, AbstractRaiderEntity target, float distance) {
        return originalPotion;
    }

    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        return originalPotion;
    }

    protected void tryUsingPotion() {
        if (this.field_70146_Z.nextFloat() < 0.15f && this.func_208600_a((ITag)FluidTags.field_206959_a) && !this.func_70644_a(Effects.field_76427_o)) {
            this.usePotion(this.makePotion(Potions.field_185248_t));
        } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(Effects.field_76426_n)) {
            this.usePotion(this.makePotion(Potions.field_185241_m));
        } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.usePotion(this.makePotion(this.func_70668_bt() == CreatureAttribute.field_223223_b_ ? Potions.field_185252_x : Potions.field_185250_v));
        } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(Effects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
            this.usePotion(((WitchFamilyConfig)MobFamily.WITCH.config).WITCHES.useSplashSwiftness.get() ? this.makeSplashPotion(Potions.field_185243_o) : this.makePotion(Potions.field_185243_o));
        } else {
            this.tryVariantUsingPotion();
        }
    }

    protected void tryVariantUsingPotion() {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
        this.field_82200_e = Integer.MAX_VALUE;
        this.recalculateAttackGoal();
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialWitchEntity>(this, SCALE);
    }

    public void recalculateAttackGoal() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            AIHelper.removeGoals(this.field_70714_bg, RangedAttackGoal.class);
            this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, (double)this.getSpecialData().getRangedWalkSpeed(), this.getSpecialData().getRangedAttackCooldown(), this.getSpecialData().getRangedAttackMaxRange()));
        }
    }

    public void drinkPotionUpdate() {
        --this.potionUseCooldownTimer;
        if (this.func_184730_o()) {
            if (this.potionDrinkTimer-- <= 0) {
                ItemStack drinkingItem = this.func_184614_ca();
                this.usePotion(ItemStack.field_190927_a);
                if (drinkingItem.func_77973_b() == Items.field_151068_bn) {
                    List effects = PotionUtils.func_185189_a((ItemStack)drinkingItem);
                    for (EffectInstance effect : effects) {
                        this.func_195064_c(new EffectInstance(effect));
                    }
                }
            }
        } else if (this.potionUseCooldownTimer <= 0) {
            this.tryUsingPotion();
        }
    }

    public void usePotion(ItemStack potion) {
        if (this.func_184730_o() && !potion.func_190926_b()) {
            this.usePotion(ItemStack.field_190927_a);
        }
        if (potion.func_190926_b()) {
            if (this.func_184730_o()) {
                this.func_82197_f(false);
                this.potionDrinkTimer = 0;
                ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
                if (attribute != null) {
                    attribute.func_111124_b(DRINKING_SPEED_PENALTY);
                }
                this.func_184201_a(EquipmentSlotType.MAINHAND, this.sheathedItem);
                this.sheathedItem = ItemStack.field_190927_a;
            }
        } else if (potion.func_77973_b() == Items.field_151068_bn) {
            ModifiableAttributeInstance attribute;
            this.sheathedItem = this.func_184614_ca();
            this.func_184201_a(EquipmentSlotType.MAINHAND, potion);
            this.func_82197_f(true);
            this.potionDrinkTimer = this.func_184614_ca().func_77988_m();
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            if ((attribute = this.func_110148_a(Attributes.field_233821_d_)) != null) {
                attribute.func_111124_b(DRINKING_SPEED_PENALTY);
                attribute.func_233767_b_(DRINKING_SPEED_PENALTY);
            }
        } else if (potion.func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI) {
            this.potionUseCooldownTimer = 40;
            PotionEntity thrownPotion = new PotionEntity(this.field_70170_p, (LivingEntity)this);
            thrownPotion.func_213884_b(potion);
            thrownPotion.field_70125_A += 20.0f;
            thrownPotion.func_70186_c(0.0, -1.0, 0.0, 0.2f, 0.0f);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            this.field_70170_p.func_217376_c((Entity)thrownPotion);
        } else {
            SpecialMobs.LOG.warn("Witch {} attempted to use '{}' as a potion! Gross!", (Object)this.getClass().getSimpleName(), (Object)potion);
        }
    }

    public ItemStack makePotion(Potion type) {
        return this.newPotion((IItemProvider)Items.field_151068_bn, type);
    }

    public ItemStack makePotion(Collection<EffectInstance> effects) {
        return this.newPotion((IItemProvider)Items.field_151068_bn, effects);
    }

    public ItemStack makeSplashPotion(Potion type) {
        return this.newPotion((IItemProvider)Items.field_185155_bH, type);
    }

    public ItemStack makeSplashPotion(Collection<EffectInstance> effects) {
        return this.newPotion((IItemProvider)Items.field_185155_bH, effects);
    }

    public ItemStack makeLingeringPotion(Potion type) {
        return this.newPotion((IItemProvider)Items.field_185156_bI, type);
    }

    public ItemStack makeLingeringPotion(Collection<EffectInstance> effects) {
        return this.newPotion((IItemProvider)Items.field_185156_bI, effects);
    }

    private ItemStack newPotion(IItemProvider item, Potion type) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack(item), (Potion)type);
    }

    private ItemStack newPotion(IItemProvider item, Collection<EffectInstance> effects) {
        return PotionUtils.func_185184_a((ItemStack)new ItemStack(item), effects);
    }

    @Override
    public SpecialMobData<_SpecialWitchEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialWitchEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            this.drinkPotionUpdate();
            this.fakeDrinkingPotion = true;
        }
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    public boolean func_184730_o() {
        if (this.fakeDrinkingPotion) {
            this.fakeDrinkingPotion = false;
            return true;
        }
        return super.func_184730_o();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_230270_dK_() && source.func_76364_f() instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        CompoundNBT itemTag = new CompoundNBT();
        if (!this.sheathedItem.func_190926_b()) {
            this.sheathedItem.func_77955_b(itemTag);
        }
        saveTag.func_218657_a("SheathedItem", (INBT)itemTag);
        saveTag.func_74777_a("PotionUseTimer", (short)this.potionDrinkTimer);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b("SheathedItem", References.NBT_TYPE_COMPOUND)) {
            this.sheathedItem = ItemStack.func_199557_a((CompoundNBT)saveTag.func_74775_l("SheathedItem"));
        }
        if (saveTag.func_150297_b("PotionUseTimer", 99)) {
            this.potionDrinkTimer = saveTag.func_74765_d("PotionUseTimer");
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.recalculateAttackGoal();
    }

    static {
        DRINKING_SPEED_PENALTY = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
        SCALE = EntityDataManager.func_187226_a(_SpecialWitchEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

