/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

@SpecialMob
public class WindWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WindWitchEntity> SPECIES;
    private int teleportDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(6523058).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureBaseOnly().addExperience(2).fallImmune().multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wind Witch", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WindWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151008_G);
        loot.addSemicommonDrop("semicommon", (IItemProvider)Items.field_151079_bi);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WindWitchEntity> getVariantFactory() {
        return WindWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WindWitchEntity> getSpecies() {
        return SPECIES;
    }

    public WindWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((CreatureEntity)this, 1.0);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, true, false);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        MobHelper.floatInFluid((Entity)this, 0.06, (ITag<Fluid>)FluidTags.field_206959_a);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && this.teleportDelay-- <= 0 && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0) {
            if (this.func_70638_az().func_70068_e((Entity)this) > 64.0) {
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleportTowards((Entity)this.func_70638_az())) continue;
                    this.teleportDelay = 60;
                    this.func_195063_d(Effects.field_76441_p);
                    break;
                }
            } else {
                MobHelper.applyDurationEffect((LivingEntity)this, Effects.field_76441_p, 30);
                for (int i = 0; i < 16; ++i) {
                    if (!this.teleport()) continue;
                    this.teleportDelay = 30;
                    break;
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.func_230279_az_() && source.func_76347_k()) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.func_70097_a(source, amount);
        if (!this.field_70170_p.func_201670_d() && this.func_110143_aJ() > 0.0f) {
            if (source.func_76346_g() instanceof LivingEntity) {
                this.teleportDelay -= 15;
                if (this.teleportDelay <= 0 && this.field_70146_Z.nextFloat() < 0.5f) {
                    for (int i = 0; i < 16 && !this.teleport(); ++i) {
                    }
                } else {
                    this.func_195063_d(Effects.field_76441_p);
                }
            } else if (this.field_70146_Z.nextInt(10) != 0) {
                this.teleport();
            }
        }
        return success;
    }

    protected boolean teleport() {
        if (this.field_70170_p.func_201670_d() || !this.func_70089_S()) {
            return false;
        }
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(12) - 4);
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 20.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vector3d directionFromTarget = new Vector3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_226283_e_(0.5) - target.func_226280_cw_(), this.func_226281_cx_() - target.func_226281_cx_()).func_72432_b();
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72450_a * 10.0;
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(8) - 2) - directionFromTarget.field_72448_b * 10.0;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - directionFromTarget.field_72449_c * 10.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        while (pos.func_177956_o() > 0) {
            BlockState block = this.field_70170_p.func_180495_p((BlockPos)pos);
            if (block.func_185904_a().func_76230_c() || block.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)(y + 1.0), (double)z);
                if (event.isCanceled()) {
                    return false;
                }
                boolean success = this.uncheckedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
                if (success && !this.func_174814_R()) {
                    this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187557_bK, this.func_184176_by(), 1.0f, 1.0f);
                    this.func_184185_a(SoundEvents.field_187557_bK, 1.0f, 1.0f);
                }
                return success;
            }
            pos.func_189536_c(Direction.DOWN);
            y -= 1.0;
        }
        return false;
    }

    private boolean uncheckedTeleport(double x, double y, double z, boolean spawnParticles) {
        double xI = this.func_226277_ct_();
        double yI = this.func_226278_cu_();
        double zI = this.func_226281_cx_();
        if (this.field_70170_p.func_175667_e(new BlockPos(x, y, z))) {
            this.func_70634_a(x, y, z);
            if (this.field_70170_p.func_226669_j_((Entity)this) && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                if (spawnParticles) {
                    References.EntityEvent.TELEPORT_TRAIL_PARTICLES.broadcast((LivingEntity)this);
                }
                this.func_70661_as().func_75499_g();
                return true;
            }
        }
        this.func_70634_a(xI, yI, zI);
        return false;
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }
}

