/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WildsWitchSpeciesConfig;
import fathertoast.specialmobs.common.entity.spider.BabySpiderEntity;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class WildsWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WildsWitchEntity> SPECIES;
    private int spiderMounts;
    private int spiderSwarms;
    private int spiderSwarmSize;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11013646).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(1).spider().multiplyAttribute(Attributes.field_233821_d_, 0.7);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new WildsWitchSpeciesConfig(species, 1, 3, 3, 6, 3, 4);
    }

    public WildsWitchSpeciesConfig getConfig() {
        return (WildsWitchSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of the Wilds", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WildsWitchEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196143_cW});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WildsWitchEntity> getVariantFactory() {
        return WildsWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WildsWitchEntity> getSpecies() {
        return SPECIES;
    }

    public WildsWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
        this.spiderMounts = this.getConfig().WILDS.mounts.next(this.field_70146_Z);
        this.spiderSwarms = this.getConfig().WILDS.swarms.next(this.field_70146_Z);
        this.spiderSwarmSize = this.getConfig().WILDS.swarmSize.next(this.field_70146_Z);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (this.spiderSwarms > 0 && this.field_70146_Z.nextFloat() < 0.33f) {
            --this.spiderSwarms;
            ILivingEntityData groupData = null;
            for (int i = 0; i < this.spiderSwarmSize; ++i) {
                groupData = this.spawnBaby(groupData);
            }
            this.func_70656_aK();
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            return ItemStack.field_190927_a;
        }
        if (!target.func_70644_a(Effects.field_76436_u)) {
            return this.makeSplashPotion(Potions.field_185219_B);
        }
        Potion originalType = PotionUtils.func_185191_c((ItemStack)originalPotion);
        if (originalType == Potions.field_185252_x || originalType == Potions.field_185253_y) {
            return this.makeSplashPotion(Potions.field_185219_B);
        }
        return originalPotion;
    }

    @Nullable
    private ILivingEntityData spawnBaby(@Nullable ILivingEntityData groupData) {
        BabySpiderEntity baby = (BabySpiderEntity)((EntityType)BabySpiderEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
        if (baby == null) {
            return groupData;
        }
        baby.func_82149_j((Entity)this);
        baby.field_70759_as = this.field_70177_z;
        baby.field_70761_aq = this.field_70177_z;
        groupData = baby.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, groupData, null);
        baby.func_70624_b(this.func_70638_az());
        baby.func_213293_j((this.field_70146_Z.nextDouble() - 0.5) * 0.33, this.field_70146_Z.nextDouble() * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.33);
        baby.func_230245_c_(false);
        this.field_70170_p.func_217376_c((Entity)baby);
        return groupData;
    }

    @Override
    protected void tryVariantUsingPotion() {
        _SpecialSpiderEntity spider;
        LivingEntity mount;
        LivingEntity livingEntity = mount = this.func_184187_bx() instanceof LivingEntity ? (LivingEntity)this.func_184187_bx() : null;
        if (mount != null && this.field_70146_Z.nextFloat() < 0.15f && mount.func_208600_a((ITag)FluidTags.field_206959_a) && !mount.func_70644_a(Effects.field_76427_o)) {
            this.usePotion(this.makeSplashPotion(Potions.field_185248_t));
        } else if (mount != null && this.field_70146_Z.nextFloat() < 0.15f && (mount.func_70027_ad() || mount.func_189748_bU() != null && mount.func_189748_bU().func_76347_k()) && !this.func_70644_a(Effects.field_76426_n)) {
            this.usePotion(this.makeSplashPotion(Potions.field_185241_m));
        } else if (mount != null && this.field_70146_Z.nextFloat() < 0.05f && mount.func_70668_bt() != CreatureAttribute.field_223223_b_ && mount.func_110143_aJ() < mount.func_110138_aP()) {
            this.usePotion(this.makeSplashPotion(Potions.field_185250_v));
        } else if (!((WitchFamilyConfig)MobFamily.WITCH.config).WITCHES.useSplashSwiftness.get() && mount != null && this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !mount.func_70644_a(Effects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
            this.usePotion(this.makeSplashPotion(Potions.field_185243_o));
        } else if (this.spiderMounts > 0 && this.field_70146_Z.nextFloat() < 0.15f && this.func_184187_bx() == null && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) > 100.0 && (spider = (_SpecialSpiderEntity)((EntityType)_SpecialSpiderEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p)) != null) {
            spider.func_82149_j((Entity)this);
            spider.field_70759_as = this.field_70177_z;
            spider.field_70761_aq = this.field_70177_z;
            if (this.field_70170_p.func_226664_a_(spider.func_174813_aQ())) {
                --this.spiderMounts;
                this.potionUseCooldownTimer = 40;
                spider.func_70624_b(this.func_70638_az());
                spider.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                this.field_70170_p.func_217376_c((Entity)spider);
                spider.func_70656_aK();
                this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.func_184205_a((Entity)spider, true);
            } else {
                spider.func_70106_y();
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Summons", (byte)this.spiderMounts);
        saveTag.func_74774_a("Babies", (byte)this.spiderSwarms);
        saveTag.func_74774_a("ExtraBabies", (byte)this.spiderSwarmSize);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Summons", 99)) {
            this.spiderMounts = saveTag.func_74771_c("Summons");
        }
        if (saveTag.func_150297_b("Babies", 99)) {
            this.spiderSwarms = saveTag.func_74771_c("Babies");
        }
        if (saveTag.func_150297_b("ExtraBabies", 99)) {
            this.spiderSwarmSize = saveTag.func_74771_c("ExtraBabies");
        }
    }
}

