/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.UndeadWitchSpeciesConfig;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class UndeadWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<UndeadWitchEntity> SPECIES;
    private int summons;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).uniqueTextureBaseOnly().addExperience(2).undead();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new UndeadWitchSpeciesConfig(species, 3, 6);
    }

    public UndeadWitchSpeciesConfig getConfig() {
        return (UndeadWitchSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lich", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        UndeadWitchEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200725_aD.func_220348_g());
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196138_cT});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<UndeadWitchEntity> getVariantFactory() {
        return UndeadWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends UndeadWitchEntity> getSpecies() {
        return SPECIES;
    }

    public UndeadWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
        this.summons = this.getConfig().UNDEAD.summons.next(this.field_70146_Z);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (this.summons > 0) {
            float f = this.field_70146_Z.nextFloat();
            float f2 = this.isNearSkeletons() ? 0.25f : 0.75f;
            if (f < f2) {
                --this.summons;
                _SpecialSkeletonEntity skeleton = (_SpecialSkeletonEntity)((EntityType)_SpecialSkeletonEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
                if (skeleton != null) {
                    skeleton.func_82149_j((Entity)this);
                    skeleton.field_70759_as = this.field_70177_z;
                    skeleton.field_70761_aq = this.field_70177_z;
                    skeleton.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                    skeleton.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
                    skeleton.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151020_U));
                    skeleton.func_70624_b(this.func_70638_az());
                    double vX = target.func_226277_ct_() - this.func_226277_ct_();
                    double vZ = target.func_226281_cx_() - this.func_226281_cx_();
                    double vH = Math.sqrt(vX * vX + vZ * vZ);
                    skeleton.func_213293_j(vX / vH * 0.7 + this.func_213322_ci().field_72450_a * 0.2, 0.4, vZ / vH * 0.7 + this.func_213322_ci().field_72449_c * 0.2);
                    skeleton.func_230245_c_(false);
                    this.field_70170_p.func_217376_c((Entity)skeleton);
                    this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    skeleton.func_70656_aK();
                    return ItemStack.field_190927_a;
                }
            }
        }
        return this.field_70146_Z.nextFloat() < 0.2f ? this.makeLingeringPotion(Potions.field_185252_x) : this.makeSplashPotion(Potions.field_185252_x);
    }

    private boolean isNearSkeletons() {
        return this.field_70170_p.func_217357_a(AbstractSkeletonEntity.class, this.func_174813_aQ().func_186662_g(11.0)).size() > 0;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Summons", (byte)this.summons);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Summons", 99)) {
            this.summons = saveTag.func_74771_c("Summons");
        }
    }
}

