/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class ShadowsWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ShadowsWitchEntity> SPECIES;
    private static final Collection<EffectInstance> POTION_SHADOWS;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).effectImmune(Effects.field_76440_q, Effects.field_82731_v);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of Shadows", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ShadowsWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_196136_br);
        loot.addRareDrop("rare", PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185234_f));
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<ShadowsWitchEntity> getVariantFactory() {
        return ShadowsWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ShadowsWitchEntity> getSpecies() {
        return SPECIES;
    }

    public ShadowsWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!(!(target.func_110143_aJ() >= 4.0f) || target.func_70644_a(Effects.field_76440_q) && target.func_70644_a(Effects.field_82731_v))) {
            return this.makeSplashPotion(POTION_SHADOWS);
        }
        return originalPotion;
    }

    @Override
    public void func_70636_d() {
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && target != null && target.func_70644_a(Effects.field_76440_q) && this.field_70146_Z.nextInt(10) == 0) {
            MobHelper.removeNightVision(target);
        }
        super.func_70636_d();
    }

    static {
        POTION_SHADOWS = Arrays.asList(new EffectInstance(Effects.field_76440_q, 300, 0), new EffectInstance(Effects.field_82731_v, 200, 0));
    }
}

