/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class IceWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<IceWitchEntity> SPECIES;
    private int wallDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(2).effectImmune(Effects.field_76421_d).addToAttribute(Attributes.field_233826_i_, 10.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Ice Witch", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        IceWitchEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Items.field_151126_ay);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_205164_gk});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<IceWitchEntity> getVariantFactory() {
        return IceWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends IceWitchEntity> getSpecies() {
        return SPECIES;
    }

    public IceWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!target.func_70644_a(Effects.field_76421_d)) {
            return this.makeSplashPotion(Potions.field_203185_t);
        }
        return originalPotion;
    }

    @Override
    public void func_70636_d() {
        double distanceSq;
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && this.wallDelay-- <= 0 && target != null && this.field_70146_Z.nextInt(20) == 0 && (distanceSq = target.func_70068_e((Entity)this)) > 100.0 && distanceSq < 196.0 && target.func_70644_a(Effects.field_76421_d) && this.func_70685_l((Entity)target)) {
            this.wallDelay = 200;
        }
        super.func_70636_d();
    }
}

