/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witch;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.witch._SpecialWitchEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

@SpecialMob
public class DominationWitchEntity
extends _SpecialWitchEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DominationWitchEntity> SPECIES;
    private static final Collection<EffectInstance> LEVITATION_EFFECTS;
    private int pullDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().addExperience(2).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch of Domination", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DominationWitchEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151062_by);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DominationWitchEntity> getVariantFactory() {
        return DominationWitchEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DominationWitchEntity> getSpecies() {
        return SPECIES;
    }

    public DominationWitchEntity(EntityType<? extends _SpecialWitchEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected ItemStack pickVariantThrownPotion(ItemStack originalPotion, LivingEntity target, float damageMulti, float distance) {
        if (!target.func_70644_a(Effects.field_76437_t)) {
            return this.makeSplashPotion(Potions.field_185226_I);
        }
        if (distance > 5.0f && !target.func_70644_a(Effects.field_188424_y) && this.field_70146_Z.nextFloat() < 0.5f) {
            return this.makeSplashPotion(LEVITATION_EFFECTS);
        }
        return originalPotion;
    }

    @Override
    public void func_70636_d() {
        double distanceSq;
        LivingEntity target = this.func_70638_az();
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && this.pullDelay-- <= 0 && target != null && this.field_70146_Z.nextInt(20) == 0 && (distanceSq = target.func_70068_e((Entity)this)) > 100.0 && distanceSq < 196.0 && (target.func_70644_a(Effects.field_76437_t) || target.func_70644_a(Effects.field_188424_y)) && this.func_70685_l((Entity)target)) {
            this.pullDelay = 100;
            this.func_184185_a(SoundEvents.field_193780_J, 1.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            MobHelper.pull((Entity)this, (Entity)target, 0.32);
        }
        super.func_70636_d();
    }

    static {
        LEVITATION_EFFECTS = Collections.singletonList(new EffectInstance(Effects.field_188424_y, 140, 0));
    }
}

