/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.world.World;

@SpecialMob
public class WitchSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WitchSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDD0E0E).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).spitAttackMultiplied(0.1, 1.0, 2.0f, 1.0).addToAttribute(Attributes.field_233826_i_, 15.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WitchSpiderEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200759_ay.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WitchSpiderEntity> getVariantFactory() {
        return WitchSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WitchSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public WitchSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected int getVariantSpitColor() {
        return 7012387;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyWitchSpiderEffect(target, this.field_70146_Z, true);
        MobHelper.stealBuffEffect((LivingEntity)this, target);
    }

    @Override
    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a().func_220303_e() != EffectType.HARMFUL && super.func_70687_e(effect);
    }
}

