/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.species.WebSpiderSpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@SpecialMob
public class WebSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WebSpiderEntity> SPECIES;
    private int webCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE7E7E7).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).spitAttackMultiplied(0.1, 1.0, 2.0f, 1.0).addToAttribute(Attributes.field_233818_a_, 4.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new WebSpiderSpeciesConfig(species, 0.02, 2, 6);
    }

    @Override
    public WebSpiderSpeciesConfig getConfig() {
        return (WebSpiderSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Weaver", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WebSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_196553_aF});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<WebSpiderEntity> getVariantFactory() {
        return WebSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WebSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public WebSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
        this.webCount = this.getConfig().WEB.webCount.next(this.field_70146_Z);
    }

    @Override
    protected int getVariantSpitColor() {
        return 0xFFFFFF;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        BlockPos pos;
        if (!this.field_70170_p.func_201670_d() && this.webCount > 0 && !(target instanceof SpiderEntity) && !this.tryPlaceWeb(pos = target.func_233580_cy_()) && target.func_213302_cg() > 1.0f) {
            this.tryPlaceWeb(pos.func_177984_a());
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean killedByPlayer) {
        super.func_213333_a(source, looting, killedByPlayer);
        this.tryPlaceWeb(this.func_233580_cy_());
    }

    private boolean tryPlaceWeb(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j() && MobHelper.placeBlock((Entity)this, pos, Blocks.field_196553_aF.func_176223_P())) {
            --this.webCount;
            return true;
        }
        return false;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Ammo", (byte)this.webCount);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Ammo", 99)) {
            this.webCount = saveTag.func_74771_c("Ammo");
        }
    }
}

