/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class PoisonSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PoisonSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(803406).theme(BestiaryInfo.Theme.FOREST).vanillaTextureWithEyes("textures/entity/spider/cave_spider.png", "textures/entity/spider_eyes.png").addExperience(1);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Venomous Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PoisonSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151070_bp});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<PoisonSpiderEntity> getVariantFactory() {
        return PoisonSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PoisonSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public PoisonSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76436_u);
    }
}

