/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.MotherSpiderSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.spider.BabySpiderEntity;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class MotherSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MotherSpiderEntity> SPECIES;
    private int babies;
    private int extraBabies;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xB300B3).uniqueTextureWithEyes().size(1.2f, 1.7f, 1.0f).addExperience(1).regen(30).addToAttribute(Attributes.field_233818_a_, 16.0).addToAttribute(Attributes.field_233826_i_, 6.0).addToAttribute(Attributes.field_233823_f_, 3.0).addToRangedDamage(1.5);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new MotherSpiderSpeciesConfig(species, 0.1, 2, 4, 3, 6);
    }

    @Override
    public MotherSpiderSpeciesConfig getConfig() {
        return (MotherSpiderSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mother Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MotherSpiderEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196143_cW});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<MotherSpiderEntity> getVariantFactory() {
        return MotherSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MotherSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public MotherSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
        this.babies = this.getConfig().MOTHER.babies.next(this.field_70146_Z);
        this.extraBabies = this.getConfig().MOTHER.extraBabies.next(this.field_70146_Z);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.extraBabies > 0 && amount > 1.0f && this.field_70170_p instanceof IServerWorld && this.field_70146_Z.nextFloat() < 0.33f) {
                --this.extraBabies;
                this.spawnBaby(0.66f, null);
                this.func_70656_aK();
                this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
            return true;
        }
        return false;
    }

    public void remove(boolean keepData) {
        if (this.func_233643_dh_() && !this.field_70128_L && this.field_70170_p instanceof IServerWorld) {
            int babiesToSpawn = this.babies + this.extraBabies;
            ILivingEntityData groupData = null;
            for (int i = 0; i < babiesToSpawn; ++i) {
                groupData = this.spawnBaby(0.33f, groupData);
            }
            this.func_70656_aK();
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        super.remove(keepData);
    }

    @Nullable
    private ILivingEntityData spawnBaby(float speed, @Nullable ILivingEntityData groupData) {
        BabySpiderEntity baby = (BabySpiderEntity)((EntityType)BabySpiderEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
        if (baby == null) {
            return groupData;
        }
        baby.func_82149_j((Entity)this);
        baby.field_70759_as = this.field_70177_z;
        baby.field_70761_aq = this.field_70177_z;
        groupData = baby.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, groupData, null);
        baby.func_70624_b(this.func_70638_az());
        baby.func_213293_j((this.field_70146_Z.nextDouble() - 0.5) * (double)speed, 0.2 + 0.5 * this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * (double)speed);
        baby.func_230245_c_(false);
        this.field_70170_p.func_217376_c((Entity)baby);
        return groupData;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Babies", (byte)this.babies);
        saveTag.func_74774_a("ExtraBabies", (byte)this.extraBabies);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Babies", 99)) {
            this.babies = saveTag.func_74771_c("Babies");
        }
        if (saveTag.func_150297_b("ExtraBabies", 99)) {
            this.extraBabies = saveTag.func_74771_c("ExtraBabies");
        }
    }
}

