/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

@SpecialMob
public class HungrySpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HungrySpiderEntity> SPECIES;
    private static final AttributeModifier DAMAGE_BOOST;
    private static final AttributeModifier HEALTH_BOOST;
    private int growthLevel;
    private int maxHealthStacks;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureWithEyes().size(1.5f, 1.9f, 1.3f).addExperience(2).regen(40).disableRangedAttack().addToAttribute(Attributes.field_233818_a_, 4.0).addToAttribute(Attributes.field_233823_f_, -1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Hungry Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        HungrySpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151103_aS);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151034_e, Items.field_185164_cV, Items.field_151078_bh, Items.field_151076_bf, Items.field_179558_bo, Items.field_151106_aX});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<HungrySpiderEntity> getVariantFactory() {
        return HungrySpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HungrySpiderEntity> getSpecies() {
        return SPECIES;
    }

    public HungrySpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (target instanceof PlayerEntity && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            ItemStack food = MobHelper.stealRandomFood((PlayerEntity)target);
            if (!food.func_190926_b()) {
                float previousHealth = this.func_110138_aP();
                if (this.maxHealthStacks < 32) {
                    ++this.maxHealthStacks;
                }
                if (this.growthLevel < 7) {
                    ++this.growthLevel;
                }
                this.updateFeedingLevels();
                this.func_70606_j(this.func_110143_aJ() + this.func_110138_aP() - previousHealth);
                Food foodStats = food.func_77973_b().func_219967_s();
                this.func_70691_i(Math.max(foodStats == null ? 0.0f : (float)foodStats.func_221466_a(), 1.0f));
                this.func_184185_a(SoundEvents.field_187739_dZ, 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            }
        } else {
            MobHelper.stealLife((LivingEntity)this, target, 2.0f);
        }
    }

    private void updateFeedingLevels() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance health = this.func_110148_a(Attributes.field_233818_a_);
            ModifiableAttributeInstance damage = this.func_110148_a(Attributes.field_233823_f_);
            health.func_188479_b(HEALTH_BOOST.func_111167_a());
            damage.func_188479_b(DAMAGE_BOOST.func_111167_a());
            if (this.maxHealthStacks > 0) {
                health.func_233769_c_(new AttributeModifier(HEALTH_BOOST.func_111167_a(), HEALTH_BOOST.func_111166_b(), HEALTH_BOOST.func_111164_d() * (double)this.maxHealthStacks, HEALTH_BOOST.func_220375_c()));
            }
            if (this.growthLevel > 0) {
                damage.func_233769_c_(new AttributeModifier(DAMAGE_BOOST.func_111167_a(), DAMAGE_BOOST.func_111166_b(), DAMAGE_BOOST.func_111164_d() * (double)this.growthLevel, DAMAGE_BOOST.func_220375_c()));
            }
        }
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("HealthStacks", (byte)this.maxHealthStacks);
        saveTag.func_74774_a("GrowthLevel", (byte)this.growthLevel);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("HealthStacks", 99)) {
            this.maxHealthStacks = saveTag.func_74771_c("HealthStacks");
        }
        if (saveTag.func_150297_b("GrowthLevel", 99)) {
            this.growthLevel = saveTag.func_74771_c("GrowthLevel");
        }
        this.updateFeedingLevels();
    }

    static {
        DAMAGE_BOOST = new AttributeModifier(UUID.fromString("70457CAB-AA09-4E1C-B44B-99DD4A2A836D"), "Feeding damage boost", 1.0, AttributeModifier.Operation.ADDITION);
        HEALTH_BOOST = new AttributeModifier(UUID.fromString("D22A70EF-7C71-4BC5-8B23-7045728FD84F"), "Feeding health boost", 2.0, AttributeModifier.Operation.ADDITION);
    }
}

