/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.spider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.spider._SpecialSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@SpecialMob
public class FireSpiderEntity
extends _SpecialSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14656027).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune().waterSensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Firefang", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireSpiderEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151044_h});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FireSpiderEntity> getVariantFactory() {
        return FireSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public FireSpiderEntity(EntityType<? extends _SpecialSpiderEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected int getVariantSpitColor() {
        return 14656027;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        BlockPos pos;
        if (!this.field_70170_p.func_201670_d() && this.field_70170_p.func_180495_p(pos = target.func_233580_cy_()).func_185904_a().func_76222_j()) {
            MobHelper.placeBlock((Entity)this, pos, Blocks.field_150480_ab.func_176223_P());
        }
        target.func_70015_d(5);
    }
}

