/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.SlimeFamilyConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialSlimeEntity
extends SlimeEntity
implements ISpecialMob<_SpecialSlimeEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialSlimeEntity> SPECIES;
    private static final DataParameter<Float> SCALE;
    private static ListNBT slimeAttributeSnapshot;
    private int slimeExperienceValue;
    private SpecialMobData<_SpecialSlimeEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(8306542).vanillaTextureBaseOnly("textures/entity/slime/slime.png").experience(0);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialSlimeEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, _SpecialSlimeEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends SlimeEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return SlimeEntity.func_223366_c(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Slime", "Slime", "Slime", "Slime", "Slime", "Schleim", "Cube o' Slime");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200743_ai.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialSlimeEntity> getFactory() {
        return _SpecialSlimeEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    private static ListNBT getAttributeSnapshot() {
        if (slimeAttributeSnapshot == null) {
            slimeAttributeSnapshot = new AttributeModifierManager(_SpecialSlimeEntity.createAttributes().func_233813_a_()).func_233794_c_();
        }
        return slimeAttributeSnapshot;
    }

    public _SpecialSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialSlimeEntity>(this, SCALE);
    }

    protected boolean func_70800_m() {
        return ((SlimeFamilyConfig)MobFamily.SLIME.config).SLIMES.tinySlimesDealDamage.get() ? this.func_70613_aW() : super.func_70800_m();
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        this.func_233645_dx_().func_233788_a_(_SpecialSlimeEntity.getAttributeSnapshot());
        super.func_70799_a(size, resetHealth);
        this.getSpecies().config.GENERAL.attributeChanges.apply((LivingEntity)this);
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.setExperience(this.getExperience());
    }

    @Override
    public SpecialMobData<_SpecialSlimeEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialSlimeEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.slimeExperienceValue;
    }

    @Override
    public final void setExperience(int xp) {
        this.slimeExperienceValue = xp;
        this.field_70728_aV = this.func_70809_q() + xp;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_230270_dK_() && source.func_76364_f() instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialSlimeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

