/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class StrawberrySlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<StrawberrySlimeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(12478827).theme(BestiaryInfo.Theme.FIRE).uniqueTextureBaseOnly().addExperience(1).fireImmune().waterSensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Strawberry Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        StrawberrySlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz, 1);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_222078_li});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<StrawberrySlimeEntity> getVariantFactory() {
        return StrawberrySlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends StrawberrySlimeEntity> getSpecies() {
        return SPECIES;
    }

    public StrawberrySlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.LAVA, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.func_70015_d(this.func_70809_q() * 3);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, 1);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, false, true);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        MobHelper.floatInFluid((Entity)this, 0.05, (ITag<Fluid>)FluidTags.field_206960_b);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.LAVA, PathNodeType.WALKABLE.func_186289_a());
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197631_x;
    }
}

