/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.species.PotionSlimeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.RegistryEntryList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@SpecialMob
public class PotionSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<PotionSlimeEntity> SPECIES;
    private static final DataParameter<Integer> COLOR;
    private static final int EMPTY_POTION_COLOR = 3694022;
    private Effect potionEffect;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11093797).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithOverlay().addExperience(2).addToAttribute(Attributes.field_233818_a_, 2.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new PotionSlimeSpeciesConfig(species);
    }

    public PotionSlimeSpeciesConfig getConfig() {
        return (PotionSlimeSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Potion Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        PotionSlimeEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185246_r), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185252_x), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185254_z), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185226_I));
        loot.addRareDrop("rare", PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_203185_t), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185253_y), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185219_B), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185252_x));
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<PotionSlimeEntity> getVariantFactory() {
        return PotionSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends PotionSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public PotionSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.setRandomPotionFill();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)3694022);
    }

    private void setRandomPotionFill() {
        Set allowedPotions = ((RegistryEntryList)this.getConfig().POTION.allowedPotions.get()).getEntries();
        if (allowedPotions.size() > 0) {
            ArrayList effects = new ArrayList(allowedPotions);
            if (!Config.MAIN.GENERAL.enableNausea.get()) {
                effects.remove(Effects.field_76431_k);
            }
            if (effects.size() > 0) {
                this.setPotionFill((Effect)effects.get(this.field_70146_Z.nextInt(effects.size())));
                return;
            }
        }
        this.setPotionFill(null);
    }

    private void setPotionFill(@Nullable Effect effect) {
        this.potionEffect = effect;
        this.field_70180_af.func_187227_b(COLOR, (Object)(effect == null ? 3694022 : effect.func_76401_j()));
    }

    public int getPotionColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.potionEffect == null) {
            target.func_70066_B();
        } else {
            MobHelper.applyEffect(target, this.potionEffect);
        }
    }

    protected boolean spawnCustomParticles() {
        int color = this.getPotionColor();
        float r = References.getRed(color);
        float g = References.getGreen(color);
        float b = References.getBlue(color);
        int size = this.func_70809_q();
        for (int i = 0; i < size * 8; ++i) {
            float angle = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            float distance = (this.field_70146_Z.nextFloat() * 0.25f + 0.25f) * (float)size;
            this.field_70170_p.func_195594_a(this.func_195404_m(), this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)angle) * distance), this.func_226278_cu_(), this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)angle) * distance), (double)r, (double)g, (double)b);
        }
        return true;
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197625_r;
    }

    @Override
    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a().func_220303_e() != EffectType.HARMFUL && super.func_70687_e(effect);
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74778_a("Ammo", SpecialMobs.toString(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)this.potionEffect)));
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Ammo", References.NBT_TYPE_STRING)) {
            this.setPotionFill((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(saveTag.func_74779_i("Ammo"))));
        }
    }

    static {
        COLOR = EntityDataManager.func_187226_a(PotionSlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

