/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@SpecialMob
public class LemonSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LemonSlimeEntity> SPECIES;
    private static final IParticleData JUMP_PARTICLE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15132769).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(2).fireImmune().addToAttribute(Attributes.field_233818_a_, 4.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lemon Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LemonSlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151137_ax, 1);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_222081_ls});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<LemonSlimeEntity> getVariantFactory() {
        return LemonSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LemonSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public LemonSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        ExplosionHelper.spawnLightning(this.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        float forwardPower = 1.1f;
        float upwardPower = 1.0f;
        Vector3d vKnockback = new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), 0.0, target.func_226281_cx_() - this.func_226281_cx_()).func_72432_b().func_186678_a((double)-1.1f).func_178787_e(this.func_213322_ci().func_186678_a((double)0.2f));
        this.func_213293_j(vKnockback.field_72450_a, 0.4, vKnockback.field_72449_c);
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightningBolt) {
    }

    protected IParticleData func_195404_m() {
        return JUMP_PARTICLE;
    }

    static {
        JUMP_PARTICLE = new ItemParticleData(ParticleTypes.field_197591_B, Items.field_222081_ls.func_190903_i());
    }
}

