/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialLeapAtTargetGoal;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class GrapeSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GrapeSlimeEntity> SPECIES;
    private static final IParticleData JUMP_PARTICLE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xB333B3).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureBaseOnly().addExperience(1).fallImmune().addToAttribute(Attributes.field_233818_a_, 4.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Grape Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GrapeSlimeEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (IItemProvider)Items.field_151123_aH, 1);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_196126_bm});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<GrapeSlimeEntity> getVariantFactory() {
        return GrapeSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GrapeSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public GrapeSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SpecialLeapAtTargetGoal((MobEntity)this, 10, 6.0f, 12.0f, 1.1f, 2.6f));
    }

    protected IParticleData func_195404_m() {
        return JUMP_PARTICLE;
    }

    static {
        JUMP_PARTICLE = new ItemParticleData(ParticleTypes.field_197591_B, Items.field_196126_bm.func_190903_i());
    }
}

