/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@SpecialMob
public class FrozenSlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenSlimeEntity> SPECIES;
    private byte frostWalking;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7760828).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).effectImmune(Effects.field_76421_d).addToAttribute(Attributes.field_233826_i_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenSlimeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Blocks.field_150432_aD);
        loot.addRareDrop("rare", new IItemProvider[]{Blocks.field_205164_gk});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FrozenSlimeEntity> getVariantFactory() {
        return FrozenSlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenSlimeEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenSlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void func_70799_a(int size, boolean resetHealth) {
        super.func_70799_a(size, resetHealth);
        this.frostWalking = (byte)-1;
        while (size > 0) {
            size >>= 1;
            this.frostWalking = (byte)(this.frostWalking + 1);
        }
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, 1);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, true, false);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        MobHelper.floatInFluid((Entity)this, 0.06, (ITag<Fluid>)FluidTags.field_206959_a);
        MobHelper.hopOnFluid((Entity)this);
    }

    protected void func_184594_b(BlockPos pos) {
        super.func_184594_b(pos);
        MobHelper.updateFrostWalker((LivingEntity)this, pos, this.frostWalking);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 4, 0.5f);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197593_D;
    }
}

