/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.slime;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.slime._SpecialSlimeEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@SpecialMob
public class BlueberrySlimeEntity
extends _SpecialSlimeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BlueberrySlimeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7760828).theme(BestiaryInfo.Theme.WATER).uniqueTextureBaseOnly().addExperience(1).drownImmune().fluidPushImmune().addToAttribute(Attributes.field_233823_f_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        SpeciesConfig.NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS = new EnvironmentList(EnvironmentEntry.builder(0.0f).atNoMoonLight().build(), EnvironmentEntry.builder(0.04f).atMaxMoonLight().build(), EnvironmentEntry.builder(0.01f).belowHalfMoonLight().build(), EnvironmentEntry.builder(0.02f).atHalfMoonLight().build(), EnvironmentEntry.builder(0.03f).aboveHalfMoonLight().build());
        return new SpeciesConfig(species);
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends BlueberrySlimeEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, EntitySpawnPlacementRegistry.PlacementType.IN_WATER, BlueberrySlimeEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends BlueberrySlimeEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        Biome.Category biomeCategory = world.func_226691_t_(pos).func_201856_r();
        if (biomeCategory == Biome.Category.OCEAN || biomeCategory == Biome.Category.RIVER) {
            return NaturalSpawnManager.checkSpawnRulesWater(type, world, reason, pos, random);
        }
        return _SpecialSlimeEntity.checkFamilySpawnRules(type, world, reason, pos, random);
    }

    public boolean func_205019_a(IWorldReader world) {
        return world.func_226668_i_((Entity)this);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Blueberry Slime", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BlueberrySlimeEntity.addBaseLoot(loot);
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151074_bl, Items.field_179562_cC, Items.field_179563_cD});
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_222083_lx});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<BlueberrySlimeEntity> getVariantFactory() {
        return BlueberrySlimeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BlueberrySlimeEntity> getSpecies() {
        return SPECIES;
    }

    public BlueberrySlimeEntity(EntityType<? extends _SpecialSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, 1);
    }

    public void func_70071_h_() {
        float range;
        double dZ;
        double dX;
        super.func_70071_h_();
        double floatAccel = 0.06;
        LivingEntity target = this.func_70638_az();
        if (target != null && target.func_226283_e_(0.5) < this.func_226283_e_(0.5) && (dX = target.func_226277_ct_() - this.func_226277_ct_()) * dX + (dZ = target.func_226281_cx_() - this.func_226281_cx_()) * dZ < (double)((range = (target.func_213311_cf() + this.func_213311_cf() + 0.1f) / 2.0f) * range)) {
            floatAccel = -0.12;
        }
        if (this.field_70173_aa > 1 && this.func_233571_b_((ITag)FluidTags.field_206959_a) > 0.0 && (!ISelectionContext.func_216374_a((Entity)this).func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_(), true) || this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a))) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, floatAccel, 0.0));
        }
    }

    public boolean func_70026_G() {
        return true;
    }

    public boolean func_203008_ap() {
        return true;
    }

    protected float func_189749_co() {
        return 0.9f;
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_218422_X;
    }
}

