/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.SkeletonFamilyConfig;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialSkeletonEntity
extends AbstractSkeletonEntity
implements ISpecialMob<_SpecialSkeletonEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialSkeletonEntity> SPECIES;
    protected static final double DEFAULT_BOW_CHANCE = 0.95;
    protected static final double DEFAULT_SHIELD_CHANCE = 0.05;
    private static final DataParameter<Float> SCALE;
    private Goal currentAttackAI;
    private static final DataParameter<Boolean> IS_BABY;
    private SpecialMobData<_SpecialSkeletonEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x494949).vanillaTextureBaseOnly("textures/entity/skeleton/skeleton.png").experience(5).undead().bowAttack(2.0, 1.0, 1.0, 20, 15.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(species, 0.95, 0.05);
    }

    public SkeletonSpeciesConfig getConfig() {
        return (SkeletonSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return SkeletonEntity.func_234275_m_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialSkeletonEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton", "Esqueleto", "Esqueleto", "Squelette", "Scheletro", "Skelett", "Bag o' Bones");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200741_ag.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialSkeletonEntity> getFactory() {
        return _SpecialSkeletonEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    protected int getVariantAttackPriority() {
        return 4;
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_82196_d(LivingEntity target, float damageMulti) {
        ItemStack arrowItem = this.func_213356_f(this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrowEntity arrow = this.func_213624_b(arrowItem, damageMulti);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(arrow);
        }
        double dX = target.func_226277_ct_() - this.func_226277_ct_();
        double dY = target.func_226283_e_(0.3333) - arrow.func_226278_cu_();
        double dZ = target.func_226281_cx_() - this.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        arrow.func_70186_c(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - 4 * this.field_70170_p.func_175659_aa().func_151525_a()));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    protected AbstractArrowEntity func_213624_b(ItemStack arrowItem, float damageMulti) {
        return this.getVariantArrow(super.func_213624_b(arrowItem, damageMulti * this.getSpecialData().getRangedAttackDamage() / 2.0f), arrowItem, damageMulti);
    }

    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return arrow;
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialSkeletonEntity>(this, SCALE);
        this.field_70180_af.func_187214_a(IS_BABY, (Object)false);
    }

    public void func_85036_m() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            if (this.currentAttackAI != null) {
                this.field_70714_bg.func_85156_a(this.currentAttackAI);
            }
            SpecialMobData<_SpecialSkeletonEntity> data = this.getSpecialData();
            ItemStack weapon = this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            this.currentAttackAI = data.getRangedAttackMaxRange() > 0.0f && weapon.func_77973_b() == Items.field_151031_f ? new RangedBowAttackGoal((MonsterEntity)this, (double)data.getRangedWalkSpeed(), data.getRangedAttackCooldown(), data.getRangedAttackMaxRange()) : new MeleeAttackGoal((CreatureEntity)this, 1.2, false);
            this.field_70714_bg.func_75776_a(this.getVariantAttackPriority(), this.currentAttackAI);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean killedByPlayer) {
        CreeperEntity creeper;
        super.func_213333_a(source, looting, killedByPlayer);
        Entity entity = source.func_76346_g();
        if (entity instanceof CreeperEntity && (creeper = (CreeperEntity)entity).func_70650_aV()) {
            creeper.func_175493_co();
            this.func_199703_a((IItemProvider)Items.field_196182_dv);
        }
    }

    public void func_82227_f(boolean value) {
        this.func_184212_Q().func_187227_b(IS_BABY, (Object)value);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance attributeInstance = this.func_110148_a(Attributes.field_233821_d_);
            attributeInstance.func_111124_b(References.BABY_SPEED_BOOST);
            if (value) {
                attributeInstance.func_233767_b_(References.BABY_SPEED_BOOST);
            }
        }
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_BABY);
    }

    public void func_184206_a(DataParameter<?> parameter) {
        if (IS_BABY.equals(parameter)) {
            this.func_213323_x_();
        }
        super.func_184206_a(parameter);
    }

    protected int func_70693_a(PlayerEntity player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public double func_70033_W() {
        return super.func_70033_W() + (this.func_70631_g_() ? 0.45 : 0.0);
    }

    @Override
    public SpecialMobData<_SpecialSkeletonEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.func_82227_f(((SkeletonFamilyConfig)MobFamily.SKELETON.config).SKELETONS.babyChance.rollChance(this.field_70146_Z));
        if (this.getSpecialData().getRangedAttackMaxRange() <= 0.0f || !this.getConfig().SKELETONS.bowEquipChance.rollChance(this.field_70146_Z)) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
            if (this.getConfig().SKELETONS.shieldEquipChance.rollChance(this.field_70146_Z)) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
            }
        }
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
        this.func_85036_m();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76364_f();
        if (this.func_230270_dK_() && entity instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        if (amount > 0.0f && MobHelper.tryBlockAttack((LivingEntity)this, source, true)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a("IsBaby", this.func_70631_g_());
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b("IsBaby", 99)) {
            this.func_82227_f(saveTag.func_74767_n("IsBaby"));
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.func_85036_m();
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        IS_BABY = EntityDataManager.func_187226_a(_SpecialSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    }
}

