/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class StraySkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<StraySkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).vanillaTextureWithOverlay("textures/entity/skeleton/stray.png", "textures/entity/skeleton/stray_overlay.png").addExperience(1);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return StrayEntity.func_234275_m_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends StraySkeletonEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, StraySkeletonEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends StraySkeletonEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return NaturalSpawnManager.checkSpawnRulesDefault(type, world, reason, pos, random) && (reason == SpawnReason.SPAWNER || world.func_226660_f_(pos));
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Stray", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200750_ap.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<StraySkeletonEntity> getVariantFactory() {
        return StraySkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends StraySkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public StraySkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 2.0f);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, Effects.field_76421_d, 2.0f);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    @Override
    protected SoundEvent func_190727_o() {
        return SoundEvents.field_190035_gx;
    }
}

