/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

@SpecialMob
public class SpitfireSkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SpitfireSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14424576).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().size(1.5f, 0.9f, 2.99f).addExperience(2).fireImmune().waterSensitive().rangedDamage(0.0).addToAttribute(Attributes.field_233818_a_, 20.0).addToAttribute(Attributes.field_233823_f_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(species, 1.0, 0.05);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Spitfire Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SpitfireSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SpitfireSkeletonEntity> getVariantFactory() {
        return SpitfireSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SpitfireSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public SpitfireSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.func_70015_d(10);
    }

    @Override
    public void func_82196_d(LivingEntity target, float damageMulti) {
        References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        float accelVariance = MathHelper.func_76129_c((float)this.func_70032_d((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        for (int i = 0; i < 3; ++i) {
            double dX = target.func_226277_ct_() - this.func_226277_ct_() + this.func_70681_au().nextGaussian() * (double)accelVariance;
            double dY = target.func_226280_cw_() - this.func_226280_cw_();
            double dZ = target.func_226281_cx_() - this.func_226281_cx_() + this.func_70681_au().nextGaussian() * (double)accelVariance;
            SmallFireballEntity fireball = new SmallFireballEntity(this.field_70170_p, (LivingEntity)this, dX, dY, dZ);
            fireball.func_70107_b(fireball.func_226277_ct_(), this.func_226280_cw_() - 0.1, fireball.func_226281_cx_());
            this.field_70170_p.func_217376_c((Entity)fireball);
        }
    }

    @Override
    public void func_82227_f(boolean value) {
    }

    @Override
    public boolean func_70631_g_() {
        return false;
    }
}

