/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.event.PlayerVelocityWatcher;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

@SpecialMob
public class SniperSkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SniperSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4744992).uniqueTextureWithOverlay().addExperience(1).multiplyRangedSpread(0.05).multiplyRangedWalkSpeed(0.3).multiplyRangedCooldown(1.5f).rangedMaxRange(25.0).addToAttribute(Attributes.field_233823_f_, 2.0).addToRangedDamage(4.0).addToAttribute(Attributes.field_233819_b_, 16.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(species, 1.0, 0.05);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Sniper Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SniperSkeletonEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (IItemProvider)Items.field_151032_g, 1);
        loot.addClusterDrop("uncommon", (IItemProvider)Items.field_185166_h, 4);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<SniperSkeletonEntity> getVariantFactory() {
        return SniperSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SniperSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public SniperSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void func_82196_d(LivingEntity target, float damageMulti) {
        double g = 0.05;
        float v = 1.6f;
        double dist = this.func_70032_d((Entity)target);
        double arcFactor = dist * 0.012;
        float ticksToTarget = (float)(dist / (double)1.6f * (1.0 + arcFactor * arcFactor * arcFactor));
        Vector3d targetV = PlayerVelocityWatcher.getVelocity((Entity)target);
        double dX = target.func_226277_ct_() + targetV.field_72450_a * (double)ticksToTarget - this.func_226277_ct_();
        double dY = target.func_226283_e_(0.5) - this.func_226280_cw_() + 0.1;
        double dZ = target.func_226281_cx_() + targetV.field_72449_c * (double)ticksToTarget - this.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        double radical = 6.553600311279297 - 0.05 * (0.05 * dH * dH + 2.0 * dY * (double)1.6f * (double)1.6f);
        if (radical < 0.0) {
            super.func_82196_d(target, damageMulti);
            return;
        }
        double angle = Math.atan((2.56000018119812 - Math.sqrt(radical)) / (0.05 * dH));
        double vY = Math.sin(angle);
        double vH = Math.cos(angle);
        ItemStack arrowItem = this.func_213356_f(this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrowEntity arrow = this.func_213624_b(arrowItem, damageMulti);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(arrow);
        }
        arrow.func_70186_c(dX / dH * vH, vY, dZ / dH * vH, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - 4 * this.field_70170_p.func_175659_aa().func_151525_a()));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    @Override
    protected AbstractArrowEntity getVariantArrow(AbstractArrowEntity arrow, ItemStack arrowItem, float damageMulti) {
        arrow.func_70240_a(arrow.field_70256_ap + 2);
        return arrow;
    }
}

