/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.INinja;
import fathertoast.specialmobs.common.entity.ai.goal.NinjaGoal;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class NinjaSkeletonEntity
extends _SpecialSkeletonEntity
implements INinja {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<NinjaSkeletonEntity> SPECIES;
    private static final DataParameter<Boolean> IS_HIDING;
    private static final DataParameter<Optional<BlockState>> HIDING_BLOCK;
    private boolean canHide = true;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x333366).uniqueOverlayTexture().addExperience(2).pressurePlateImmune().multiplyRangedCooldown(0.5f).rangedMaxRange(9.0).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(species, 0.5, 0.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton Ninja", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        NinjaSkeletonEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_196686_dc, Blocks.field_196687_dd, Blocks.field_196688_de, Blocks.field_196692_dg, Blocks.field_196690_df, Blocks.field_196694_dh});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<NinjaSkeletonEntity> getVariantFactory() {
        return NinjaSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends NinjaSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public NinjaSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        this.field_70714_bg.func_75776_a(-9, new NinjaGoal<NinjaSkeletonEntity>(this));
    }

    @Override
    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.func_98053_h(true);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        this.revealTo(target, true);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (source.func_76346_g() instanceof LivingEntity) {
                this.revealTo((LivingEntity)source.func_76346_g(), false);
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.func_201670_d() && this.getHiddenDragon() != null) {
            this.revealTo((LivingEntity)player, true);
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70100_b_(PlayerEntity player) {
        if (!this.field_70170_p.func_201670_d() && this.getHiddenDragon() != null && !player.func_184812_l_()) {
            this.revealTo((LivingEntity)player, true);
        }
        super.func_70100_b_(player);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.func_201670_d()) {
            if (this.canHide) {
                this.setHiddenDragon(NinjaGoal.pickDisguise(this));
            } else if (this.field_70122_E && this.getHiddenDragon() == null && (this.func_70638_az() == null || this.func_70638_az() instanceof PlayerEntity && ((PlayerEntity)this.func_70638_az()).func_184812_l_())) {
                this.canHide = true;
            }
        }
        super.func_70071_h_();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isCrouchingTiger() ? null : super.func_184639_G();
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        if (!this.isCrouchingTiger()) {
            super.func_70012_b(x, y, z, yaw, pitch);
        }
    }

    public void func_213317_d(Vector3d vec) {
        if (!this.isCrouchingTiger()) {
            super.func_213317_d(vec);
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && !this.isCrouchingTiger();
    }

    @Override
    public void func_241209_g_(int ticks) {
        if (!this.isCrouchingTiger()) {
            super.func_241209_g_(ticks);
        }
    }

    public void revealTo(LivingEntity target, boolean ambush) {
        if (this.getHiddenDragon() == null) {
            return;
        }
        this.setHiddenDragon(null);
        if (!(target instanceof PlayerEntity) || !((PlayerEntity)target).func_184812_l_()) {
            this.func_70624_b(target);
            if (ambush) {
                MobHelper.applyEffect(target, Effects.field_76436_u);
                MobHelper.applyEffect(target, Effects.field_76421_d);
                MobHelper.applyEffect(target, Effects.field_76440_q);
                MobHelper.removeNightVision(target);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HIDING, (Object)false);
        this.field_70180_af.func_187214_a(HIDING_BLOCK, Optional.empty());
    }

    @Override
    public boolean isCrouchingTiger() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_HIDING);
    }

    @Override
    public void setCrouchingTiger(boolean value) {
        if (value != this.isCrouchingTiger()) {
            this.func_184212_Q().func_187227_b(IS_HIDING, (Object)value);
        }
    }

    @Override
    @Nullable
    public BlockState getHiddenDragon() {
        if (this.func_70089_S()) {
            return ((Optional)this.func_184212_Q().func_187225_a(HIDING_BLOCK)).orElse(null);
        }
        return null;
    }

    @Override
    public void setHiddenDragon(@Nullable BlockState block) {
        this.func_184212_Q().func_187227_b(HIDING_BLOCK, Optional.ofNullable(block));
        this.canHide = false;
        if (block == null) {
            this.func_70656_aK();
        }
    }

    static {
        IS_HIDING = EntityDataManager.func_187226_a(NinjaSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        HIDING_BLOCK = EntityDataManager.func_187226_a(NinjaSkeletonEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    }
}

