/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

@SpecialMob
public class KnightSkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<KnightSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDDDDD).addExperience(2).multiplyRangedSpread(1.2).addToAttribute(Attributes.field_233818_a_, 10.0).addToAttribute(Attributes.field_233823_f_, 4.0).addToRangedDamage(4.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(species, 0.05, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Skeleton Knight", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        KnightSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_191525_da);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<KnightSkeletonEntity> getVariantFactory() {
        return KnightSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends KnightSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public KnightSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151165_aa));
        this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab));
    }
}

