/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.IAngler;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousGoToShoreGoal;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousSwimUpGoal;
import fathertoast.specialmobs.common.entity.ai.goal.AnglerGoal;
import fathertoast.specialmobs.common.entity.ai.goal.PassiveRangedAttackGoal;
import fathertoast.specialmobs.common.entity.silverfish.AmphibiousSilverfishEntity;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.datagen.loot.LootPoolBuilder;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class FishingSilverfishEntity
extends AmphibiousSilverfishEntity
implements IAngler {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FishingSilverfishEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2966004).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FISHING).uniqueTextureBaseOnly().size(1.2f, 0.5f, 0.4f).addExperience(2).drownImmune().fluidPushImmune().convertRangedAttackToFishing(1.0, 40, 10.0).addToAttribute(Attributes.field_233818_a_, 4.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SilverfishSpeciesConfig(species, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Fishing Silverfish", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FishingSilverfishEntity.addBaseLoot(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196086_aW).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addPool(new LootPoolBuilder("semicommon").addEntry(new LootEntryItemBuilder((IItemProvider)Items.field_196087_aX).setCount(0, 1).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FishingSilverfishEntity> getVariantFactory() {
        return FishingSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FishingSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public FishingSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.field_70714_bg, PassiveRangedAttackGoal.class);
        this.field_70714_bg.func_75776_a(4, new AnglerGoal<FishingSilverfishEntity>(this));
        AIHelper.removeGoals(this.field_70714_bg, SwimGoal.class);
        AIHelper.insertGoal(this.field_70714_bg, 5, new AmphibiousGoToShoreGoal<FishingSilverfishEntity>(this, 1.0).alwaysEnabled());
        AIHelper.insertGoal(this.field_70714_bg, 6, new AmphibiousSwimUpGoal<FishingSilverfishEntity>(this, 1.0).alwaysEnabled());
    }

    @Override
    public void setLineOut(boolean value) {
    }

    @Override
    public boolean isLineOut() {
        return false;
    }
}

