/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class FireSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireSilverfishEntity> SPECIES;
    private byte auraCooldown = (byte)20;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14656027).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Firebrat", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireSilverfishEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151044_h});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FireSilverfishEntity> getVariantFactory() {
        return FireSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public FireSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected int getVariantSpitColor() {
        return 14656027;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.func_70015_d(5);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        byte by = this.auraCooldown;
        this.auraCooldown = (byte)(by - 1);
        if (by <= 0) {
            this.auraCooldown = (byte)30;
            this.pulseAura();
        }
    }

    private void pulseAura() {
        List friends = this.field_70170_p.func_217357_a(SilverfishEntity.class, this.func_174813_aQ().func_186662_g(7.0));
        for (SilverfishEntity cutie : friends) {
            if (!cutie.func_70089_S() || cutie.func_230279_az_()) continue;
            cutie.func_195064_c(new EffectInstance(Effects.field_76426_n, 35 + this.field_70146_Z.nextInt(16), 0, true, true));
        }
    }
}

