/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DesiccatedSilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@SpecialMob
public class DesiccatedSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DesiccatedSilverfishEntity> SPECIES;
    private int absorbCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE7E7E7).theme(BestiaryInfo.Theme.DESERT).uniqueTextureBaseOnly().addExperience(1).undead().addToAttribute(Attributes.field_233818_a_, 4.0).addToAttribute(Attributes.field_233826_i_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new DesiccatedSilverfishSpeciesConfig(species, 0.05, 64, 64);
    }

    @Override
    public DesiccatedSilverfishSpeciesConfig getConfig() {
        return (DesiccatedSilverfishSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Desiccated Silverfish", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DesiccatedSilverfishEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.field_200725_aD.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<DesiccatedSilverfishEntity> getVariantFactory() {
        return DesiccatedSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DesiccatedSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public DesiccatedSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, World world) {
        super(entityType, world);
        this.absorbCount = this.getConfig().DESICCATED.absorbCount.next(this.field_70146_Z);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.func_201670_d() && this.absorbCount > 0 && this.spongebob()) {
            this.func_70656_aK();
        }
        super.func_70636_d();
    }

    @Override
    protected int getVariantSpitColor() {
        return Effects.field_76438_s.func_76401_j();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76438_s);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    private boolean spongebob() {
        int initialCount = this.absorbCount;
        ArrayDeque<Tuple<BlockPos, Integer>> posToCheckAround = new ArrayDeque<Tuple<BlockPos, Integer>>();
        this.tryAbsorb(posToCheckAround, -1, this.func_233580_cy_());
        block0: while (!posToCheckAround.isEmpty() && this.absorbCount > 0) {
            Tuple tuple = (Tuple)posToCheckAround.poll();
            BlockPos rootPos = (BlockPos)tuple.func_76341_a();
            int rootDistance = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                this.tryAbsorb(posToCheckAround, rootDistance, rootPos.func_177972_a(direction));
                if (this.absorbCount <= 0) continue block0;
            }
        }
        return initialCount > this.absorbCount;
    }

    private void tryAbsorb(Queue<Tuple<BlockPos, Integer>> posToCheckAround, int rootDistance, BlockPos pos) {
        if (!this.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return;
        }
        BlockState block = this.field_70170_p.func_180495_p(pos);
        if (block.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)block.func_177230_c()).func_204508_a((IWorld)this.field_70170_p, pos, block) != Fluids.field_204541_a) {
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        } else if (block.func_177230_c() instanceof FlowingFluidBlock) {
            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        } else if (block.func_185904_a() == Material.field_203243_f || block.func_185904_a() == Material.field_204868_h) {
            TileEntity tileEntity = block.hasTileEntity() ? this.field_70170_p.func_175625_s(pos) : null;
            Block.func_220059_a((BlockState)block, (IWorld)this.field_70170_p, (BlockPos)pos, (TileEntity)tileEntity);
            this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        }
    }

    private void onAbsorb(Queue<Tuple<BlockPos, Integer>> posToCheckAround, int rootDistance, BlockPos pos) {
        if (rootDistance < 6) {
            posToCheckAround.add((Tuple<BlockPos, Integer>)new Tuple((Object)pos, (Object)(rootDistance + 1)));
        }
        this.func_70691_i(1.0f);
        --this.absorbCount;
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("Ammo", (byte)this.absorbCount);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("Ammo", 99)) {
            this.absorbCount = saveTag.func_74771_c("Ammo");
        }
    }
}

