/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class AlbinoSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<AlbinoSilverfishEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xFFFFFF).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).effectImmune(Effects.field_76421_d).addToAttribute(Attributes.field_233826_i_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new SilverfishSpeciesConfig(species, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Albino Silverfish", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        AlbinoSilverfishEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151126_ay);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<AlbinoSilverfishEntity> getVariantFactory() {
        return AlbinoSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends AlbinoSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public AlbinoSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected int getVariantSpitColor() {
        return Effects.field_76421_d.func_76401_j();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 2);
    }
}

