/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpecialFishingBobberEntity
extends ProjectileEntity
implements IEntityAdditionalSpawnData {
    private static final float DRAG_FACTOR = 0.92f;
    private static final float GRAVITY_ACCEL = 0.03f;
    private float maxRangeSq = 1024.0f;

    public SpecialFishingBobberEntity(EntityType<? extends SpecialFishingBobberEntity> entityType, World world) {
        super(entityType, world);
    }

    public SpecialFishingBobberEntity(LivingEntity angler, LivingEntity target) {
        super((EntityType)SMEntities.FISHING_BOBBER.get(), angler.field_70170_p);
        this.func_212361_a((Entity)angler);
        Vector3d lookVec = angler.func_70676_i(1.0f).func_186678_a((double)angler.func_213311_cf());
        this.func_70107_b(angler.func_226277_ct_() + lookVec.field_72450_a, angler.func_226280_cw_() - 0.1, angler.func_226281_cx_() + lookVec.field_72449_c);
        float spread = 18 - 4 * this.field_70170_p.func_175659_aa().func_151525_a();
        if (angler instanceof ISpecialMob) {
            ISpecialMob specialShooter = (ISpecialMob)angler;
            if (specialShooter.getSpecialData().getRangedAttackMaxRange() >= 0.0f) {
                this.maxRangeSq = 2.0f * specialShooter.getSpecialData().getRangedAttackMaxRange();
                this.maxRangeSq *= this.maxRangeSq;
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no max range stat! {}", (Object)angler);
            }
            if (specialShooter.getSpecialData().getRangedAttackSpread() >= 0.0f) {
                spread *= specialShooter.getSpecialData().getRangedAttackSpread();
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no ranged spread stat! {}", (Object)angler);
            }
        }
        double dX = target.func_226277_ct_() - this.func_226277_ct_();
        double dY = target.func_226283_e_(0.3333) - this.func_226278_cu_();
        double dZ = target.func_226281_cx_() - this.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.func_70186_c(dX, dY + dH * 0.2, dZ, 1.3f, spread);
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        Entity owner = this.func_234616_v_();
        buffer.writeInt(owner == null ? 0 : owner.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int ownerId = additionalData.readInt();
        this.func_212361_a(this.field_70170_p.func_73045_a(ownerId));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB boundingBox = super.func_184177_bl();
        Entity owner = this.func_234616_v_();
        return owner == null ? boundingBox : boundingBox.func_111270_a(owner.func_184177_bl());
    }

    @Nullable
    public LivingEntity getLivingOwner() {
        Entity owner = this.func_234616_v_();
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        LivingEntity angler = this.getLivingOwner();
        if (!this.field_70170_p.func_201670_d() && (angler == null || this.func_70068_e((Entity)angler) > (double)this.maxRangeSq)) {
            this.func_70106_y();
            return;
        }
        RayTraceResult rayTrace = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((SpecialFishingBobberEntity)this).func_230298_a_(arg_0));
        if (rayTrace.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)rayTrace)) {
            this.func_70227_a(rayTrace);
        }
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.func_203005_aq() ? (double)0.06f : (double)-0.03f, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_234617_x_();
        this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.92f));
        this.func_226264_Z_();
    }

    protected void func_70227_a(RayTraceResult hit) {
        super.func_70227_a(hit);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult hit) {
        super.func_213868_a(hit);
        this.func_184185_a(SoundEvents.field_193780_J, 1.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        MobHelper.pull(this.func_234616_v_(), hit.func_216348_a(), 0.32);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74776_a("MaxRange", this.maxRangeSq);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("MaxRange", 99)) {
            this.maxRangeSq = tag.func_74760_g("MaxRange");
        }
    }
}

