/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.event.PlayerVelocityWatcher;
import fathertoast.specialmobs.common.util.References;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class IncorporealFireballEntity
extends AbstractFireballEntity
implements IEntityAdditionalSpawnData {
    public int explosionPower = 1;
    private boolean shouldExplode = false;
    @Nullable
    private LivingEntity target;

    public IncorporealFireballEntity(EntityType<? extends AbstractFireballEntity> entityType, World world) {
        super(entityType, world);
    }

    public IncorporealFireballEntity(World world, CorporealShiftGhastEntity ghast, double x, double y, double z) {
        super((EntityType)SMEntities.INCORPOREAL_FIREBALL.get(), (LivingEntity)ghast, x, y, z, world);
        this.explosionPower = ghast.func_175453_cd();
        this.target = ghast.func_70638_az();
    }

    public IncorporealFireballEntity(World world, @Nullable PlayerEntity owner, @Nullable LivingEntity target, double x, double y, double z) {
        this((EntityType<? extends AbstractFireballEntity>)((EntityType)SMEntities.INCORPOREAL_FIREBALL.get()), world);
        this.func_70107_b(x, y, z);
        this.target = target;
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_226264_Z_();
        double d = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        if (d != 0.0) {
            this.field_70232_b = x / d * 0.1;
            this.field_70233_c = y / d * 0.1;
            this.field_70230_d = z / d * 0.1;
        }
        if (owner != null) {
            this.func_212361_a((Entity)owner);
            this.func_70101_b(owner.field_70177_z, owner.field_70125_A);
        }
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Incorporeal Fireball", "", "", "", "", "", "");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target == null || !this.target.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        Vector3d vector3d = new Vector3d(this.target.func_226277_ct_() - this.func_226277_ct_(), this.target.func_226278_cu_() + (double)(this.target.func_70047_e() / 2.0f) - this.func_226278_cu_(), this.target.func_226281_cx_() - this.func_226281_cx_());
        this.func_213317_d(vector3d.func_72432_b().func_186678_a(0.5));
        if (!this.field_70170_p.field_72995_K && this.shouldExplode) {
            this.explode();
        }
    }

    private void explode() {
        boolean mobGrief = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.func_234616_v_());
        Explosion.Mode mode = mobGrief ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
        this.field_70170_p.func_217398_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)this.explosionPower, mobGrief, mode);
        this.target = null;
        this.func_70106_y();
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected void func_70227_a(RayTraceResult traceResult) {
        super.func_70227_a(traceResult);
    }

    protected void func_213868_a(EntityRayTraceResult traceResult) {
        super.func_213868_a(traceResult);
        if (!this.field_70170_p.field_72995_K) {
            Entity target = traceResult.func_216348_a();
            if (target instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)target;
                if (PlayerVelocityWatcher.get(player).isMoving()) {
                    this.explode();
                    return;
                }
            } else if (target.func_226277_ct_() != target.field_70169_q || target.func_226278_cu_() != target.field_70167_r || target.func_226281_cx_() != target.field_70166_s) {
                this.explode();
                return;
            }
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource) || damageSource.func_76347_k()) {
            return false;
        }
        this.shouldExplode = true;
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)SMItems.INCORPOREAL_FIREBALL.get());
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("ExplosionPower", this.explosionPower);
        compoundNBT.func_74768_a("TargetId", this.target == null ? -1 : this.target.func_145782_y());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        Entity entity;
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("ExplosionPower", 99)) {
            this.explosionPower = compoundNBT.func_74762_e("ExplosionPower");
        }
        if (compoundNBT.func_150297_b("TargetId", 99) && (entity = this.field_70170_p.func_73045_a(compoundNBT.func_74762_e("TargetId"))) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        Entity owner = this.func_234616_v_();
        buffer.writeInt(owner == null ? 0 : owner.func_145782_y());
        buffer.writeInt(this.target == null ? 0 : this.target.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int ownerId = additionalData.readInt();
        int targetId = additionalData.readInt();
        this.func_212361_a(this.field_70170_p.func_73045_a(ownerId));
        if (this.field_70170_p.func_73045_a(targetId) instanceof LivingEntity) {
            this.target = (LivingEntity)this.field_70170_p.func_73045_a(targetId);
        }
    }
}

