/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class BugSpitEntity
extends ProjectileEntity {
    private static final float DRAG_FACTOR = 0.99f;
    private static final float GRAVITY_ACCEL = 0.06f;
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(BugSpitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float damageAmount = 2.0f;
    private int knockback;

    public BugSpitEntity(EntityType<? extends BugSpitEntity> entityType, World world) {
        super(entityType, world);
    }

    public BugSpitEntity(LivingEntity shooter, LivingEntity target) {
        super((EntityType)SMEntities.BUG_SPIT.get(), shooter.field_70170_p);
        this.func_212361_a((Entity)shooter);
        Vector3d lookVec = shooter.func_70676_i(1.0f).func_186678_a((double)shooter.func_213311_cf());
        this.func_70107_b(shooter.func_226277_ct_() + lookVec.field_72450_a, shooter.func_226280_cw_() - 0.1, shooter.func_226281_cx_() + lookVec.field_72449_c);
        float spread = 14 - 4 * this.field_70170_p.func_175659_aa().func_151525_a();
        if (shooter instanceof ISpecialMob) {
            ISpecialMob specialShooter = (ISpecialMob)shooter;
            this.setDamage(specialShooter.getSpecialData().getRangedAttackDamage());
            if (this.getDamage() < 0.0f) {
                SpecialMobs.LOG.warn("Entity is shooting damaging projectile, but has no ranged damage stat! {}", (Object)shooter);
                this.setDamage(2.0f);
            }
            if (specialShooter.getSpecialData().getRangedAttackSpread() >= 0.0f) {
                spread *= specialShooter.getSpecialData().getRangedAttackSpread();
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no ranged spread stat! {}", (Object)shooter);
            }
        }
        double dX = target.func_226277_ct_() - this.func_226277_ct_();
        double dY = target.func_226283_e_(0.3333) - this.func_226278_cu_();
        double dZ = target.func_226281_cx_() - this.func_226281_cx_();
        double dH = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.func_70186_c(dX, dY + dH * 0.2, dZ, 1.2f, spread);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0xFFFFFF);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p != null && this.field_70170_p.func_201670_d()) {
            Vector3d v = this.func_213322_ci();
            for (int i = 0; i < 7; ++i) {
                double multi = 0.4 + 0.1 * (double)i;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197602_M, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), v.field_72450_a * multi, v.field_72448_b * multi, v.field_72449_c * multi);
            }
        }
    }

    public void setDamage(float amount) {
        this.damageAmount = amount;
    }

    public float getDamage() {
        return this.damageAmount;
    }

    public void setKnockback(int amount) {
        this.knockback = amount;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d v = this.func_213322_ci();
        RayTraceResult rayTrace = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((BugSpitEntity)this).func_230298_a_(arg_0));
        if (rayTrace.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)rayTrace)) {
            this.func_70227_a(rayTrace);
        }
        double nextX = this.func_226277_ct_() + v.field_72450_a;
        double nextY = this.func_226278_cu_() + v.field_72448_b;
        double nextZ = this.func_226281_cx_() + v.field_72449_c;
        this.func_234617_x_();
        if (this.field_70170_p.func_234853_a_(this.func_174813_aQ()).noneMatch(AbstractBlock.AbstractBlockState::func_196958_f) || this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(v.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(nextX, nextY, nextZ);
        }
    }

    protected void func_70227_a(RayTraceResult hit) {
        super.func_70227_a(hit);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult hit) {
        super.func_213868_a(hit);
        Entity target = hit.func_216348_a();
        Entity owner = this.func_234616_v_();
        if (owner instanceof LivingEntity && target.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)((LivingEntity)owner)).func_76349_b(), this.getDamage())) {
            if (this.getKnockback() > 0 && target instanceof LivingEntity) {
                MobHelper.knockback((Entity)this, (LivingEntity)target, (float)this.getKnockback(), 1.0f);
            }
            owner.func_174815_a((LivingEntity)owner, target);
            ((LivingEntity)owner).func_130011_c(target);
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74776_a("RangedDamage", this.getDamage());
        tag.func_74768_a("Knockback", this.getKnockback());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("RangedDamage", 99)) {
            this.setDamage(tag.func_74760_g("RangedDamage"));
        }
        if (tag.func_150297_b("Knockback", 99)) {
            this.setKnockback(tag.func_74762_e("Knockback"));
        }
    }
}

