/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.magmacube;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.ai.IExplodingMob;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialSwellGoal;
import fathertoast.specialmobs.common.entity.magmacube._SpecialMagmaCubeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayList;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

@SpecialMob
public class VolatileMagmaCubeEntity
extends _SpecialMagmaCubeEntity
implements IExplodingMob {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<VolatileMagmaCubeEntity> SPECIES;
    private static final byte MAX_FUSE = 30;
    private int fuse = 0;
    private boolean ignited = false;
    private int swellDir = 0;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x331133).uniqueTextureBaseOnly().addExperience(2).addToAttribute(Attributes.field_233818_a_, 2.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Volatile Magma Cube", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        VolatileMagmaCubeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151016_H);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<VolatileMagmaCubeEntity> getVariantFactory() {
        return VolatileMagmaCubeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends VolatileMagmaCubeEntity> getSpecies() {
        return SPECIES;
    }

    public VolatileMagmaCubeEntity(EntityType<? extends _SpecialMagmaCubeEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void registerVariantGoals() {
        this.field_70714_bg.func_75776_a(0, new SpecialSwellGoal<VolatileMagmaCubeEntity>(this));
    }

    public void func_70071_h_() {
        if (this.func_70089_S() && !this.field_70170_p.func_201670_d()) {
            if (this.ignited) {
                this.setSwellDir(1);
            }
            if (this.getSwellDir() > 0) {
                if (this.fuse == 0) {
                    this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
                } else if (this.fuse >= 30) {
                    this.field_70729_aU = true;
                    ExplosionHelper.explode((Entity)this, (float)this.func_70809_q() + 0.5f, true, false);
                    this.func_70106_y();
                    this.spawnLingeringCloud();
                } else {
                    this.changeFuse(1);
                }
            } else if (this.getSwellDir() < 0 && this.fuse > 0) {
                this.changeFuse(-1);
                if (this.fuse <= 0) {
                    this.setSwellDir(0);
                }
            }
        }
        super.func_70071_h_();
    }

    private void changeFuse(int change) {
        this.fuse += change;
        this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + (float)change * 0.014f);
    }

    protected void spawnLingeringCloud() {
        ArrayList effects = new ArrayList(this.func_70651_bq());
        if (!effects.isEmpty()) {
            AreaEffectCloudEntity potionCloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            potionCloud.func_184483_a((float)this.func_70809_q() + 0.5f);
            potionCloud.func_184495_b(-0.5f);
            potionCloud.func_184485_d(10);
            potionCloud.func_184486_b(potionCloud.func_184489_o() / 2);
            potionCloud.func_184487_c(-potionCloud.func_184490_j() / (float)potionCloud.func_184489_o());
            for (EffectInstance effect : effects) {
                potionCloud.func_184496_a(new EffectInstance(effect));
            }
            this.field_70170_p.func_217376_c((Entity)potionCloud);
        }
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    @Override
    public boolean func_225503_b_(float distance, float damageMultiplier) {
        boolean success = super.func_225503_b_(distance, damageMultiplier);
        this.changeFuse((int)(distance * 1.5f));
        if (this.fuse > 25) {
            this.changeFuse(25 - this.fuse);
        }
        return success;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (item.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.ignited = true;
                item.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74774_a("FuseTime", (byte)this.fuse);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("FuseTime", 99)) {
            this.fuse = saveTag.func_74771_c("FuseTime");
        }
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197601_L;
    }

    @Override
    public void setSwellDir(int value) {
        this.swellDir = value;
    }

    @Override
    public int getSwellDir() {
        return this.swellDir;
    }

    @Override
    public double getExtraRange() {
        return (float)(this.func_70809_q() - 1) * 2.0f;
    }
}

