/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.GhastFamilyConfig;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.SimpleFlyingMovementController;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialGhastFireballAttackGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialGhastLookAroundGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialGhastMeleeAttackGoal;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@SpecialMob
public class _SpecialGhastEntity
extends GhastEntity
implements IRangedAttackMob,
ISpecialMob<_SpecialGhastEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialGhastEntity> SPECIES;
    private static final DataParameter<Float> SCALE;
    private Goal currentAttackAI;
    private SpecialMobData<_SpecialGhastEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xBCBCBC).vanillaTextureWithAnimation("textures/entity/ghast/ghast.png", "textures/entity/ghast/ghast_shooting.png").experience(5).fireballAttack(0.0, 20, 40, 64.0);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return GhastEntity.func_234290_eH_().func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialGhastEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, _SpecialGhastEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends GhastEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return GhastEntity.func_223368_b(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, reason, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Ghast", "Ghast", "Ghast", "Ghast", "Ghast", "Ghast", "Ghast");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.field_200811_y.func_220348_g());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<_SpecialGhastEntity> getFactory() {
        return _SpecialGhastEntity::new;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        AIHelper.removeGoals(this.field_70714_bg, 7);
        this.field_70714_bg.func_75776_a(7, (Goal)new SpecialGhastLookAroundGoal(this));
        if (((GhastFamilyConfig)MobFamily.GHAST.config).GHASTS.allowVerticalTargeting.get()) {
            AIHelper.removeGoals(this.field_70715_bh, NearestAttackableTargetGoal.class);
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    protected int getVariantAttackPriority() {
        return 4;
    }

    public void finalizeVariantSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
    }

    public void func_82196_d(LivingEntity target, float damageMulti) {
        References.LevelEvent.GHAST_SHOOT.play((Entity)this);
        float accelVariance = MathHelper.func_76129_c((float)this.func_70032_d((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        Vector3d lookVec = this.func_70676_i(1.0f).func_186678_a((double)this.func_213311_cf());
        double dX = target.func_226277_ct_() - (this.func_226277_ct_() + lookVec.field_72450_a) + this.func_70681_au().nextGaussian() * (double)accelVariance;
        double dY = target.func_226283_e_(0.5) - (0.5 + this.func_226283_e_(0.5));
        double dZ = target.func_226281_cx_() - (this.func_226281_cx_() + lookVec.field_72449_c) + this.func_70681_au().nextGaussian() * (double)accelVariance;
        FireballEntity fireball = new FireballEntity(this.field_70170_p, (LivingEntity)this, dX, dY, dZ);
        fireball.field_92057_e = this.getVariantExplosionPower(this.func_175453_cd());
        fireball.func_70107_b(this.func_226277_ct_() + lookVec.field_72450_a, this.func_226283_e_(0.5) + 0.5, this.func_226281_cx_() + lookVec.field_72449_c);
        this.field_70170_p.func_217376_c((Entity)fireball);
    }

    protected int getVariantExplosionPower(int radius) {
        return radius;
    }

    public void func_174815_a(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.func_174815_a(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundNBT saveTag) {
    }

    public void readVariantSaveData(CompoundNBT saveTag) {
    }

    public _SpecialGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new SimpleFlyingMovementController((MobEntity)this);
        this.reassessAttackGoal();
        this.getSpecialData().initialize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<_SpecialGhastEntity>(this, SCALE);
    }

    public void reassessAttackGoal() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            if (this.currentAttackAI != null) {
                this.field_70714_bg.func_85156_a(this.currentAttackAI);
            }
            this.currentAttackAI = this.getSpecialData().getRangedAttackMaxRange() > 0.0f ? new SpecialGhastFireballAttackGoal(this) : new SpecialGhastMeleeAttackGoal(this);
            this.field_70714_bg.func_75776_a(this.getVariantAttackPriority(), this.currentAttackAI);
        }
    }

    @Override
    public SpecialMobData<_SpecialGhastEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialGhastEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> entityType, boolean keepEquipment) {
        MobEntity replacement = super.func_233656_b_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && this.field_70170_p instanceof IServerWorld) {
            MobHelper.finalizeSpawn((LivingEntity)replacement, (IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData groupData, @Nullable CompoundNBT eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, world, difficulty, spawnReason, super.func_213386_a(world, difficulty, spawnReason, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(PathNodeType nodeType, float malus) {
        this.func_184644_a(nodeType, malus);
    }

    protected final void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(IServerWorld world, DifficultyInstance difficulty, @Nullable SpawnReason spawnReason, @Nullable ILivingEntityData groupData) {
        this.finalizeVariantSpawn(world, difficulty, spawnReason, groupData);
        this.reassessAttackGoal();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().tick();
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return super.func_213348_b(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean func_230279_az_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void func_241209_g_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_241209_g_(ticks);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_213295_a(BlockState block, Vector3d speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.func_213295_a(block, speedMulti);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_230270_dK_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_230270_dK_() && source.func_76364_f() instanceof SnowballEntity) {
            amount = Math.max(3.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.reassessAttackGoal();
    }

    static {
        SCALE = EntityDataManager.func_187226_a(_SpecialGhastEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

