/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class UnholyGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<UnholyGhastEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(8046420).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithAnimation().size(0.5f, 2.0f, 2.0f).addExperience(4).undead().disableRangedAttack().addToAttribute(Attributes.field_233818_a_, 10.0).addToAttribute(Attributes.field_233823_f_, 2.0).multiplyAttribute(Attributes.field_233821_d_, 0.7);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Unholy Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        UnholyGhastEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151103_aS);
        loot.addSemicommonDrop("semicommon", (IItemProvider)Items.field_151128_bU);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<UnholyGhastEntity> getVariantFactory() {
        return UnholyGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends UnholyGhastEntity> getSpecies() {
        return SPECIES;
    }

    public UnholyGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (MobHelper.isDamageSourceIneffectiveAgainstVampires(source)) {
            amount = Math.min(2.0f, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public void func_70636_d() {
        if (this.func_204609_dp()) {
            ItemStack hat = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!hat.func_190926_b()) {
                if (hat.func_77984_f()) {
                    hat.func_196085_b(hat.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (hat.func_77952_i() >= hat.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
            } else {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }
}

