/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CorporealShiftGhastSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.entity.projectile.IncorporealFireballEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@SpecialMob
public class CorporealShiftGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<CorporealShiftGhastEntity> SPECIES;
    public static final DataParameter<Boolean> CORPOREAL;
    private int shiftTime;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11009947).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithAnimation().addExperience(4).regen(80).addToAttribute(Attributes.field_233818_a_, 20.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(MobFamily.Species<?> species) {
        return new CorporealShiftGhastSpeciesConfig(species, 300, 200);
    }

    public CorporealShiftGhastSpeciesConfig getConfig() {
        return (CorporealShiftGhastSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Corporeal Shift Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        CorporealShiftGhastEntity.addBaseLoot(loot);
        loot.addClusterDrop("cluster", (IItemProvider)SMItems.INCORPOREAL_FIREBALL.get());
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<CorporealShiftGhastEntity> getVariantFactory() {
        return CorporealShiftGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends CorporealShiftGhastEntity> getSpecies() {
        return SPECIES;
    }

    public CorporealShiftGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CORPOREAL, (Object)false);
        if (!this.field_70170_p.func_201670_d()) {
            this.setCorporeal(this.field_70146_Z.nextBoolean());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (--this.shiftTime <= 0 && !this.field_70170_p.func_201670_d()) {
            this.setCorporeal(!this.isCorporeal());
            this.spawnShiftSmoke((ServerWorld)this.field_70170_p);
        }
    }

    private void spawnShiftSmoke(ServerWorld world) {
        world.func_195598_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 25, 0.0, 0.0, 0.0, 0.4);
    }

    public boolean func_70104_M() {
        return this.isCorporeal() && super.func_70104_M();
    }

    protected void func_82167_n(Entity entity) {
        if (this.isCorporeal()) {
            super.func_82167_n(entity);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return this.isCorporeal() && super.func_70097_a(source, amount);
    }

    public boolean isCorporeal() {
        return (Boolean)this.field_70180_af.func_187225_a(CORPOREAL);
    }

    private void setCorporeal(boolean value) {
        this.field_70180_af.func_187227_b(CORPOREAL, (Object)value);
        this.shiftTime = value ? this.getConfig().CORPOREAL_SHIFT.corporealTicks.get() : this.getConfig().CORPOREAL_SHIFT.incorporealTicks.get();
    }

    @Override
    public void func_82196_d(LivingEntity target, float damageMulti) {
        if (this.isCorporeal()) {
            super.func_82196_d(target, damageMulti);
            return;
        }
        References.LevelEvent.GHAST_SHOOT.play((Entity)this);
        float accelVariance = MathHelper.func_76129_c((float)this.func_70032_d((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        Vector3d lookVec = this.func_70676_i(1.0f).func_186678_a((double)this.func_213311_cf());
        double dX = target.func_226277_ct_() - (this.func_226277_ct_() + lookVec.field_72450_a) + this.func_70681_au().nextGaussian() * (double)accelVariance;
        double dY = target.func_226283_e_(0.5) - (0.5 + this.func_226283_e_(0.5));
        double dZ = target.func_226281_cx_() - (this.func_226281_cx_() + lookVec.field_72449_c) + this.func_70681_au().nextGaussian() * (double)accelVariance;
        IncorporealFireballEntity fireball = new IncorporealFireballEntity(this.field_70170_p, this, dX, dY, dZ);
        fireball.explosionPower = this.getVariantExplosionPower(this.func_175453_cd());
        fireball.func_70107_b(this.func_226277_ct_() + lookVec.field_72450_a, this.func_226283_e_(0.5) + 0.5, this.func_226281_cx_() + lookVec.field_72449_c);
        this.field_70170_p.func_217376_c((Entity)fireball);
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74757_a("IsShifted", this.isCorporeal());
        saveTag.func_74777_a("ShiftTime", (short)this.shiftTime);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("IsShifted", 99)) {
            this.setCorporeal(saveTag.func_74767_n("IsShifted"));
        }
        if (saveTag.func_150297_b("ShiftTime", 99)) {
            this.shiftTime = saveTag.func_74765_d("ShiftTime");
        }
    }

    static {
        CORPOREAL = EntityDataManager.func_187226_a(CorporealShiftGhastEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    }
}

