/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

@SpecialMob
public class ThiefEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ThiefEndermanEntity> SPECIES;
    private int teleportTargetDelay;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(326144).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithEyes().addExperience(2).multiplyAttribute(Attributes.field_233821_d_, 1.2);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Thief Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ThiefEndermanEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (IItemProvider)Items.field_151079_bi, 1);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<ThiefEndermanEntity> getVariantFactory() {
        return ThiefEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ThiefEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public ThiefEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (!this.field_70170_p.func_201670_d() && target.func_70089_S() && this.teleportTargetDelay <= 0) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportTarget(target)) continue;
                this.teleportTargetDelay = 160;
                for (int j = 0; j < 16 && !this.func_70816_c((Entity)target); ++j) {
                }
                break;
            }
        }
    }

    private boolean teleportTarget(LivingEntity target) {
        EntityTeleportEvent.ChorusFruit event;
        double xI = target.func_226277_ct_();
        double yI = target.func_226278_cu_();
        double zI = target.func_226281_cx_();
        double x = xI + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = yI + (double)this.field_70146_Z.nextInt(64) - 32.0;
        double z = zI + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        if (target.func_184218_aH()) {
            target.func_184210_p();
        }
        if ((event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)target, (double)x, (double)y, (double)z)).isCanceled()) {
            return false;
        }
        if (target.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) {
            this.field_70170_p.func_184148_a(null, xI, yI, zI, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            target.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.func_201670_d()) {
            --this.teleportTargetDelay;
        }
    }
}

