/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.RunicEndermanBeamAttackGoal;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@SpecialMob
public class RunicEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<RunicEndermanEntity> SPECIES;
    public static final double BEAM_MAX_RANGE = 32.0;
    private static final DataParameter<Byte> BEAM_STATE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14951041).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureWithEyes().addExperience(2).fallImmune().burnImmune().convertRangedAttackToBeam(2.0, 1.0, 60, 100, 16.0).addToAttribute(Attributes.field_233826_i_, 10.0).addToAttribute(Attributes.field_233823_f_, 1.0).multiplyAttribute(Attributes.field_233821_d_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Runic Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        RunicEndermanEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Blocks.field_150348_b);
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_185158_cP});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<RunicEndermanEntity> getVariantFactory() {
        return RunicEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends RunicEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public RunicEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEAM_STATE, (Object)BeamState.OFF.id());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.field_70714_bg, 2, new RunicEndermanBeamAttackGoal(this));
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_188424_y);
        MobHelper.knockback((Entity)this, target, 2.0f, 0.0f);
    }

    public BeamState getBeamState() {
        return BeamState.of((Byte)this.field_70180_af.func_187225_a(BEAM_STATE));
    }

    public void setBeamState(BeamState value) {
        this.field_70180_af.func_187227_b(BEAM_STATE, (Object)value.id());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.getBeamState() == BeamState.OFF ? super.func_184177_bl() : super.func_184177_bl().func_216361_a(this.func_70676_i(1.0f).func_186678_a(32.0));
    }

    static {
        BEAM_STATE = EntityDataManager.func_187226_a(RunicEndermanEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    }

    public static enum BeamState {
        OFF,
        CHARGING,
        DAMAGING;


        public byte id() {
            return (byte)this.ordinal();
        }

        public static BeamState of(byte id) {
            return BeamState.values()[id];
        }
    }
}

