/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class MirageEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MirageEndermanEntity> SPECIES;
    public boolean isFake = false;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(12762244).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.DESERT).uniqueTextureWithEyes().addExperience(2).addToAttribute(Attributes.field_233818_a_, 20.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mirage Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MirageEndermanEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (IItemProvider)Blocks.field_150354_m, 1);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_196686_dc, Blocks.field_196687_dd, Blocks.field_196688_de, Blocks.field_196692_dg, Blocks.field_196690_df, Blocks.field_196694_dh});
        loot.addRareDrop("rare", new IItemProvider[]{Items.field_151043_k});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<MirageEndermanEntity> getVariantFactory() {
        return MirageEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MirageEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public MirageEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    public void setFake() {
        this.isFake = true;
        this.setExperience(0);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.0);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        for (int i = 0; i < 64 && !this.func_70820_n(); ++i) {
        }
    }

    public void func_70071_h_() {
        if (this.isFake && this.field_70173_aa >= 200) {
            this.func_70656_aK();
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isFake) {
            this.func_70606_j(0.0f);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean func_70825_j(double x, double y, double z) {
        if (this.isFake) {
            return false;
        }
        if (super.func_70825_j(x, y, z)) {
            this.mirage();
            return true;
        }
        return false;
    }

    private void mirage() {
        if (!this.isFake && this.func_70638_az() != null) {
            MirageEndermanEntity mirage = (MirageEndermanEntity)((EntityType)MirageEndermanEntity.SPECIES.entityType.get()).func_200721_a(this.field_70170_p);
            if (mirage == null) {
                return;
            }
            mirage.setFake();
            mirage.func_82149_j((Entity)this);
            mirage.func_70624_b(this.func_70638_az());
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.func_225653_b_(this.field_70169_q, this.field_70167_r, this.field_70166_s);
            } else {
                mirage.func_225653_b_(this.field_70169_q, this.field_70167_r, this.field_70166_s);
            }
            mirage.func_70606_j(this.func_110143_aJ());
            this.field_70170_p.func_217376_c((Entity)mirage);
        }
    }

    protected void func_213354_a(DamageSource source, boolean killedByPlayer) {
        if (!this.isFake) {
            super.func_213354_a(source, killedByPlayer);
        }
    }

    @Override
    public void addVariantSaveData(CompoundNBT saveTag) {
        saveTag.func_74757_a("IsFake", this.isFake);
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        if (saveTag.func_150297_b("IsFake", 99)) {
            this.isFake = saveTag.func_74767_n("IsFake");
        }
    }
}

