/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@SpecialMob
public class LightningEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<LightningEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x4BB4B5).theme(BestiaryInfo.Theme.STORM).uniqueTextureWithEyes().addExperience(2).fireImmune().waterInsensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Lightning Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        LightningEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151137_ax);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<LightningEndermanEntity> getVariantFactory() {
        return LightningEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends LightningEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public LightningEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        ExplosionHelper.spawnLightning(this.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        for (int i = 0; i < 64 && !this.func_70820_n(); ++i) {
        }
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightningBolt) {
    }
}

