/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;

@SpecialMob
public class IcyEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<IcyEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithEyes().addExperience(1).effectImmune(Effects.field_76421_d);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Icy Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        IcyEndermanEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (IItemProvider)Items.field_151126_ay);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Blocks.field_205164_gk});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<IcyEndermanEntity> getVariantFactory() {
        return IcyEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends IcyEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public IcyEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, Effects.field_76421_d, 5, 0.5f);
        MobHelper.applyEffect(target, Effects.field_76419_f, 3);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((CreatureEntity)this, 1.0);
    }

    protected PathNavigator func_175447_b(World world) {
        return new FluidPathNavigator((MobEntity)this, world, true, false);
    }

    public boolean func_230285_a_(Fluid fluid) {
        return fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (DamageSource.field_76369_e.equals(source)) {
            for (int i = 0; i < 64; ++i) {
                if (!this.func_70820_n()) continue;
                return true;
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184594_b(BlockPos pos) {
        super.func_184594_b(pos);
        this.updateFrostWalker(pos);
    }

    protected boolean func_70825_j(double x, double y, double z) {
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        while (pos.func_177956_o() > 0) {
            BlockState block = this.field_70170_p.func_180495_p((BlockPos)pos);
            if (block.func_185904_a().func_76230_c() || block.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)(y + 1.0), (double)z);
                if (event.isCanceled()) {
                    return false;
                }
                boolean success = this.uncheckedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
                if (success) {
                    this.updateFrostWalker(pos.func_185334_h().func_177984_a());
                    if (!this.func_174814_R()) {
                        this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    }
                }
                return success;
            }
            pos.func_189536_c(Direction.DOWN);
            y -= 1.0;
        }
        return false;
    }

    private boolean uncheckedTeleport(double x, double y, double z, boolean spawnParticles) {
        double xI = this.func_226277_ct_();
        double yI = this.func_226278_cu_();
        double zI = this.func_226281_cx_();
        if (this.field_70170_p.func_175667_e(new BlockPos(x, y, z))) {
            this.func_70634_a(x, y, z);
            if (this.field_70170_p.func_226669_j_((Entity)this) && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                if (spawnParticles) {
                    References.EntityEvent.TELEPORT_TRAIL_PARTICLES.broadcast((LivingEntity)this);
                }
                this.func_70661_as().func_75499_g();
                return true;
            }
        }
        this.func_70634_a(xI, yI, zI);
        return false;
    }

    @Override
    public void readVariantSaveData(CompoundNBT saveTag) {
        this.func_184644_a(PathNodeType.WATER, PathNodeType.WALKABLE.func_186289_a());
    }

    private void updateFrostWalker(BlockPos pos) {
        boolean actualOnGround = this.field_70122_E;
        this.field_70122_E = true;
        FrostWalkerEnchantment.func_185266_a((LivingEntity)this, (World)this.field_70170_p, (BlockPos)pos, (int)1);
        this.field_70122_E = actualOnGround;
    }
}

