/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@SpecialMob
public class FlameEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FlameEndermanEntity> SPECIES;
    private int flameRingCooldown;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14424576).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune().addToAttribute(Attributes.field_233818_a_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Flame Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FlameEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_151059_bz);
        loot.addUncommonDrop("uncommon", new IItemProvider[]{Items.field_151044_h});
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<FlameEndermanEntity> getVariantFactory() {
        return FlameEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FlameEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public FlameEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void func_70636_d() {
        --this.flameRingCooldown;
        super.func_70636_d();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.func_70015_d(4);
        for (int i = 0; i < 64 && !this.func_70820_n(); ++i) {
        }
    }

    protected boolean func_70816_c(Entity target) {
        if (super.func_70816_c(target)) {
            if (this.flameRingCooldown <= 0) {
                this.flameRingCooldown = 100 + this.field_70146_Z.nextInt(100);
                this.makeFireRing(target.func_233580_cy_());
            }
            return true;
        }
        return false;
    }

    private void makeFireRing(BlockPos center) {
        if (ExplosionHelper.getMode((Entity)this) == Explosion.Mode.NONE) {
            return;
        }
        int radius = 5;
        int rMinusOneSq = 16;
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                int distSq = x * x + z * z;
                if (distSq > 25 || distSq <= 16) continue;
                this.placeFireWall(center.func_177982_a(x, 0, z), 5);
            }
        }
    }

    private void placeFireWall(BlockPos pos, int radius) {
        BlockPos.Mutable currentPos = pos.func_239590_i_();
        currentPos.func_185336_p(Math.max(pos.func_177956_o() - radius, 0));
        int maxY = Math.min(pos.func_177956_o() + radius, this.field_70170_p.func_217301_I() - 2);
        while (currentPos.func_177956_o() < maxY) {
            currentPos.func_196234_d(0, 1, 0);
            if (!this.shouldSetFire((BlockPos)currentPos)) continue;
            MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)currentPos));
        }
    }

    private boolean shouldSetFire(BlockPos pos) {
        if (!this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return false;
        }
        if (((FireBlock)Blocks.field_150480_ab).canCatchFire((IBlockReader)this.field_70170_p, pos, Direction.UP)) {
            return true;
        }
        BlockPos posBelow = pos.func_177977_b();
        return this.field_70170_p.func_180495_p(posBelow).func_224755_d((IBlockReader)this.field_70170_p, posBelow, Direction.UP);
    }
}

