/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

@SpecialMob
public class BlindingEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BlindingEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xFFFFFF).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(1).effectImmune(Effects.field_76440_q);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Blinding Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BlindingEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (IItemProvider)Items.field_196136_br);
    }

    @SpecialMob.Factory
    public static EntityType.IFactory<BlindingEndermanEntity> getVariantFactory() {
        return BlindingEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BlindingEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public BlindingEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        LivingEntity target = this.func_70638_az();
        if (target != null && this.func_70068_e((Entity)target) < 100.0) {
            MobHelper.applyDurationEffect(target, Effects.field_76440_q, 50);
            MobHelper.removeNightVision(target);
        }
    }
}

